package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.common.api45mng.APIPort_PortType;
import ru.yandex.autotests.directapi.common.api45mng.CreateNewSubclientResponse;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.clients.ConvertType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 19.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(ApiFeatures.NOT_REGRESSION_YET)
@Description("Проверка логики поля SourceID")
@Tag(TagDictionary.NEVER_RUN)
public class GetSourceIDTest {

    private static String manager = CampaignsLogins.MANAGER_GEO;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long convertedId;
    private static Long newId;
    private static String login;

    @BeforeClass
    public static void prepareData() {
        api.as(manager).wsdl(APIPort_PortType.class);
        CreateNewSubclientResponse createNewSubclientResponse =
                api.userSteps.clientSteps().createServicedClient("subClient", manager);
        login = createNewSubclientResponse.getLogin();
        convertedId = api.userSteps.campaignSteps().addDefaultTextCampaign(login);
        api.userSteps.clientFakeSteps()
                .convertCurrency(login, Currency.RUB.toString(), ConvertType.COPY);
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(login, convertedId, CampaignFieldEnum.STATE);
        assumeThat("кампания заархивировалась после конвертации",
                campaignGetItem.getState(), equalTo(CampaignStateGetEnum.CONVERTED));
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withStates(CampaignStateEnum.SUSPENDED))
                        .withFieldNames(CampaignFieldEnum.ID),
                login);
        assumeThat("у субклиента одна несконвертированная кампания", getResponse.getCampaigns(), hasSize(1));
        newId = getResponse.getCampaigns().get(0).getId();

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("465")
    public void getByNewId() {
        //DIRECT-45234
        //DIRECT-46015
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                .withIds(newId))
                        .withFieldNames(CampaignFieldEnum.SOURCE_ID),
                login);
        assertThat("вернулся ожидаемый SourceId",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withSourceId(convertedId).getBean()
                )));
    }
}
