package ru.yandex.autotests.direct.api.campaigns.get;

import java.sql.Date;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCurrency;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCurrencyconverted;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 29.07.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля States SelectionCriteria метода Get для разных типов кампании")
public class GetStatesOfCampaignTest {

    private final static String CLIENT = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    private final static DirectJooqDbSteps JOOQ_DB_STEPS =
            api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long onTextCampaignId;
    private static Long onMobileAppCampaignId;
    private static Long onDynamicTextCampaignId;
    private static Long onCpmBannerCampaignId;
    private static Long onModifyConvertedTextCampaignId;
    private static Long onModifyConvertedMobileAppCampaignId;
    private static Long onModifyConvertedDynamicTextCampaignId;
    private static Long onModifyConvertedCpmBannerCampaignId;

    private static Long offModifyConvertedTextCampaignId;
    private static Long offModifyConvertedMobileAppCampaignId;
    private static Long offModifyConvertedDynamicTextCampaignId;
    private static Long offModifyConvertedCpmBannerCampaignId;
    private static Long offTextCampaignId;
    private static Long offMobileAppCampaignId;
    private static Long offDynamicTextCampaignId;
    private static Long offCpmBannerCampaignId;

    private static Long endedTextCampaignId;
    private static Long endedMobileAppCampaignId;
    private static Long endedDynamicTextCampaignId;
    private static Long endedCpmBannerCampaignId;
    private static Long endedModifyConvertedTextCampaignId;
    private static Long endedModifyConvertedMobileAppCampaignId;
    private static Long endedModifyConvertedDynamicTextCampaignId;
    private static Long endedModifyConvertedCpmBannerCampaignId;
    private static Long endedActiveTextCampaignId;
    private static Long endedActiveMobileAppCampaignId;
    private static Long endedActiveDynamicTextCampaignId;
    private static Long endedActiveCpmBannerCampaignId;

    private static Long archivedTextCampaignId;
    private static Long archivedMobileAppCampaignId;
    private static Long archivedDynamicTextCampaignId;
    private static Long archivedCpmBannerCampaignId;
    private static Long archivedModifyConvertedTextCampaignId;
    private static Long archivedModifyConvertedMobileAppCampaignId;
    private static Long archivedModifyConvertedDynamicTextCampaignId;
    private static Long archivedModifyConvertedCpmBannerCampaignId;

    private static Long convertedTextCampaignId;
    private static Long convertedMobileAppCampaignId;
    private static Long convertedDynamicTextCampaignId;
    private static Long convertedCpmBannerCampaignId;

    private static Long suspendedTextCampaignId;
    private static Long suspendedMobileAppCampaignId;
    private static Long suspendedDynamicTextCampaignId;
    private static Long suspendedCpmBannerCampaignId;
    private static Long suspendedModifyConvertedTextCampaignId;
    private static Long suspendedModifyConvertedMobileAppCampaignId;
    private static Long suspendedModifyConvertedDynamicTextCampaignId;
    private static Long suspendedModifyConvertedCpmBannerCampaignId;
    private static Long suspendedActiveTextCampaignId;
    private static Long suspendedActiveMobileAppCampaignId;
    private static Long suspendedActiveDynamicTextCampaignId;
    private static Long suspendedActiveCpmBannerCampaignId;

    private static Long[] campaignIds;

    @BeforeClass
    public static void createCampaigns() {
        onTextCampaignId = createCampaign(CampaignType.TEXT, CampaignStateEnum.ON);
        onMobileAppCampaignId = createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.ON);
        onDynamicTextCampaignId = createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.ON);
        onCpmBannerCampaignId = createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.ON);

        onModifyConvertedTextCampaignId =
                createCampaign(CampaignType.TEXT, CampaignStateEnum.ON);
        onModifyConvertedMobileAppCampaignId =
                createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.ON);
        onModifyConvertedDynamicTextCampaignId =
                createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.ON);
        onModifyConvertedCpmBannerCampaignId =
                createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.ON);

        offTextCampaignId = createCampaign(CampaignType.TEXT, CampaignStateEnum.OFF);
        offMobileAppCampaignId = createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.OFF);
        offDynamicTextCampaignId = createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.OFF);
        offCpmBannerCampaignId = createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.OFF);

        offModifyConvertedTextCampaignId =
                createCampaign(CampaignType.TEXT, CampaignStateEnum.OFF);
        offModifyConvertedMobileAppCampaignId =
                createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.OFF);
        offModifyConvertedDynamicTextCampaignId =
                createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.OFF);
        offModifyConvertedCpmBannerCampaignId =
                createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.OFF);

        endedTextCampaignId = createCampaign(CampaignType.TEXT, CampaignStateEnum.ENDED);
        endedMobileAppCampaignId = createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.ENDED);
        endedDynamicTextCampaignId = createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.ENDED);
        endedCpmBannerCampaignId = createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.ENDED);

        endedModifyConvertedTextCampaignId =
                createCampaign(CampaignType.TEXT, CampaignStateEnum.ENDED);
        endedModifyConvertedMobileAppCampaignId =
                createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.ENDED);
        endedModifyConvertedDynamicTextCampaignId =
                createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.ENDED);
        endedModifyConvertedCpmBannerCampaignId =
                createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.ENDED);


        // завершившиеся кампании со statusActive="Yes"
        endedActiveTextCampaignId =
                createCampaign(CampaignType.TEXT, CampaignStateEnum.ENDED, CampaignsStatusactive.Yes);
        endedActiveMobileAppCampaignId =
                createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.ENDED, CampaignsStatusactive.Yes);
        endedActiveDynamicTextCampaignId =
                createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.ENDED, CampaignsStatusactive.Yes);
        endedActiveCpmBannerCampaignId =
                createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.ENDED, CampaignsStatusactive.Yes);

        archivedTextCampaignId = createCampaign(CampaignType.TEXT, CampaignStateEnum.ARCHIVED);
        archivedMobileAppCampaignId = createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.ARCHIVED);
        archivedDynamicTextCampaignId = createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.ARCHIVED);
        archivedCpmBannerCampaignId = createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.ARCHIVED);

        // архивные кампании, конвертированные непосредственной модификацией (не копированием)
        archivedModifyConvertedTextCampaignId =
                createCampaign(CampaignType.TEXT, CampaignStateEnum.ARCHIVED);
        archivedModifyConvertedMobileAppCampaignId =
                createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.ARCHIVED);
        archivedModifyConvertedDynamicTextCampaignId =
                createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.ARCHIVED);
        archivedModifyConvertedCpmBannerCampaignId =
                createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.ARCHIVED);

        convertedTextCampaignId = createCampaign(CampaignType.TEXT, CampaignStateEnum.CONVERTED);
        convertedMobileAppCampaignId = createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.CONVERTED);
        convertedDynamicTextCampaignId = createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.CONVERTED);
        convertedCpmBannerCampaignId = createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.CONVERTED);

        suspendedTextCampaignId = createCampaign(CampaignType.TEXT, CampaignStateEnum.SUSPENDED);
        suspendedMobileAppCampaignId = createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.SUSPENDED);
        suspendedDynamicTextCampaignId = createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.SUSPENDED);
        suspendedCpmBannerCampaignId = createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.SUSPENDED);

        suspendedModifyConvertedTextCampaignId =
                createCampaign(CampaignType.TEXT, CampaignStateEnum.SUSPENDED);
        suspendedModifyConvertedMobileAppCampaignId =
                createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.SUSPENDED);
        suspendedModifyConvertedDynamicTextCampaignId =
                createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.SUSPENDED);
        suspendedModifyConvertedCpmBannerCampaignId =
                createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.SUSPENDED);

        // приостановленные, но ещё не синхронизированные с БК
        suspendedActiveTextCampaignId =
                createCampaign(CampaignType.TEXT, CampaignStateEnum.SUSPENDED, CampaignsStatusactive.Yes);
        suspendedActiveMobileAppCampaignId =
                createCampaign(CampaignType.MOBILE_CONTENT, CampaignStateEnum.SUSPENDED, CampaignsStatusactive.Yes);
        suspendedActiveDynamicTextCampaignId =
                createCampaign(CampaignType.DYNAMIC, CampaignStateEnum.SUSPENDED, CampaignsStatusactive.Yes);
        suspendedActiveCpmBannerCampaignId =
                createCampaign(CampaignType.CPM_BANNER, CampaignStateEnum.SUSPENDED, CampaignsStatusactive.Yes);

        campaignIds = new Long[]{
                onTextCampaignId, onMobileAppCampaignId, onDynamicTextCampaignId, onCpmBannerCampaignId,
                onModifyConvertedTextCampaignId, onModifyConvertedMobileAppCampaignId,
                onModifyConvertedDynamicTextCampaignId, onModifyConvertedCpmBannerCampaignId,

                offTextCampaignId, offMobileAppCampaignId, offDynamicTextCampaignId, offCpmBannerCampaignId,
                offModifyConvertedTextCampaignId, offModifyConvertedMobileAppCampaignId,
                offModifyConvertedDynamicTextCampaignId, offModifyConvertedCpmBannerCampaignId,

                endedTextCampaignId, endedMobileAppCampaignId, endedDynamicTextCampaignId, endedCpmBannerCampaignId,
                endedModifyConvertedTextCampaignId, endedModifyConvertedMobileAppCampaignId,
                endedModifyConvertedDynamicTextCampaignId, endedModifyConvertedCpmBannerCampaignId,
                endedActiveTextCampaignId, endedActiveMobileAppCampaignId, endedActiveDynamicTextCampaignId,
                endedActiveCpmBannerCampaignId,

                archivedTextCampaignId, archivedMobileAppCampaignId, archivedDynamicTextCampaignId,
                archivedCpmBannerCampaignId,
                archivedModifyConvertedTextCampaignId, archivedModifyConvertedMobileAppCampaignId,
                archivedModifyConvertedDynamicTextCampaignId, archivedModifyConvertedCpmBannerCampaignId,

                convertedTextCampaignId, convertedMobileAppCampaignId, convertedDynamicTextCampaignId,
                convertedCpmBannerCampaignId,

                suspendedTextCampaignId, suspendedMobileAppCampaignId, suspendedDynamicTextCampaignId,
                suspendedCpmBannerCampaignId,
                suspendedModifyConvertedTextCampaignId, suspendedModifyConvertedMobileAppCampaignId,
                suspendedModifyConvertedDynamicTextCampaignId, suspendedModifyConvertedCpmBannerCampaignId,

                suspendedActiveTextCampaignId, suspendedActiveMobileAppCampaignId, suspendedActiveDynamicTextCampaignId,
                suspendedActiveCpmBannerCampaignId
        };
    }

    private static Long createCampaign(CampaignType type, CampaignStateEnum state,
            CampaignsCurrency modifyConversionResultCurrency, CampaignsStatusactive statusActive)
    {
        Long campaignId = api.userSteps.campaignSteps().addDefaultCampaign(type);
        CampaignsRecord campaignsRecord = JOOQ_DB_STEPS.campaignsSteps().getCampaignById(campaignId);
        switch (state) {
            case ON:
                campaignsRecord.setStatusactive(CampaignsStatusactive.Yes).setFinishTime(Date.valueOf(LocalDate.now()));
                break;
            case OFF:
                campaignsRecord.setStatusactive(CampaignsStatusactive.No);
                break;
            case ENDED:
                campaignsRecord.setFinishTime(Date.valueOf(LocalDate.now().minusDays(1)))
                        .setStatusactive(statusActive != null ? statusActive : CampaignsStatusactive.No);
                break;
            case ARCHIVED:
                campaignsRecord.setStatusshow(CampaignsStatusshow.No).setArchived(CampaignsArchived.Yes);
                break;
            case CONVERTED:
                campaignsRecord.setCurrency(CampaignsCurrency.YND_FIXED)
                        .setCurrencyconverted(CampaignsCurrencyconverted.Yes)
                        .setArchived(CampaignsArchived.Yes)
                        .setFinishTime(Date.valueOf(LocalDate.now().minusDays(1)));
                break;
            case SUSPENDED:
                campaignsRecord.setStatusshow(CampaignsStatusshow.No);
                campaignsRecord.setStatusactive(statusActive == null ? CampaignsStatusactive.No : statusActive);
                break;
        }
        if (modifyConversionResultCurrency != null && modifyConversionResultCurrency != CampaignsCurrency.YND_FIXED) {
            campaignsRecord.setCurrency(modifyConversionResultCurrency)
                    .setCurrencyconverted(CampaignsCurrencyconverted.Yes);
        }
        JOOQ_DB_STEPS.campaignsSteps().updateCampaigns(campaignsRecord);

        return campaignId;
    }

    private static Long createCampaign(CampaignType type, CampaignStateEnum state) {
        return createCampaign(type, state, null, null);
    }

    private static Long createCampaign(CampaignType type, CampaignStateEnum state, CampaignsCurrency currency) {
        return createCampaign(type, state, currency, null);
    }

    private static Long createCampaign(CampaignType type, CampaignStateEnum state, CampaignsStatusactive statusActive) {
        return createCampaign(type, state, null, statusActive);
    }

    @Test
    public void getByAllStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignIds)
                                        .withStates(
                                                CampaignStateEnum.ON,
                                                CampaignStateEnum.OFF,
                                                CampaignStateEnum.ENDED,
                                                CampaignStateEnum.ARCHIVED,
                                                CampaignStateEnum.CONVERTED,
                                                CampaignStateEnum.SUSPENDED
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE));

        assumeThat("вернулось " + campaignIds.length + " кампаний",
                getResponse.getCampaigns(), Matchers.hasSize(campaignIds.length));

        assertThat("вернулись кампании ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedTextCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean()
                ))
        );
    }

    @Test
    public void getByOFFStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignIds)
                                        .withStates(
                                                CampaignStateEnum.OFF
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE));
        assertThat("вернулись кампании ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(offModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.OFF).getBean()
                ))
        );
    }

    @Test
    public void getByONStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignIds)
                                        .withStates(
                                                CampaignStateEnum.ON
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE));
        assertThat("вернулись кампании ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(onModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ON).getBean()
                ))
        );
    }

    @Test
    public void getBySuspendedStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignIds)
                                        .withStates(
                                                CampaignStateEnum.SUSPENDED
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE));
        assertThat("вернулись кампании ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(suspendedActiveCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.SUSPENDED).getBean()
                ))
        );
    }

    @Test
    public void getByConvertedStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignIds)
                                        .withStates(
                                                CampaignStateEnum.CONVERTED
                                        )
                        )
                        .withFieldNames(
                                CampaignFieldEnum.ID,
                                CampaignFieldEnum.STATE,
                                CampaignFieldEnum.STATUS_CLARIFICATION
                        ));
        String statusClarification = String.join(". ",
                StatusClarification.CONVERTED.getStatusClarification(),
                String.format(
                        StatusClarification.CAMPAIGN_ENDED.getStatusClarification(),
                        LocalDate.now().minusDays(1).format(DateTimeFormatter.ofPattern("dd.MM.yyyy"))
                )
        );
        assertThat("вернулись кампании ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedTextCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED)
                                .withStatusClarification(statusClarification)
                                .getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED)
                                .withStatusClarification(statusClarification)
                                .getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED)
                                .withStatusClarification(statusClarification)
                                .getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(convertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.CONVERTED)
                                .withStatusClarification(statusClarification)
                                .getBean()
                ))
        );
    }

    @Test
    public void getByArchivedStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignIds)
                                        .withStates(
                                                CampaignStateEnum.ARCHIVED
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE));
        assertThat("вернулись кампании ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(archivedModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ARCHIVED).getBean()
                ))
        );
    }

    @Test
    public void getByEndedStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignIds)
                                        .withStates(
                                                CampaignStateEnum.ENDED
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE));
        assertThat("вернулись кампании ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedModifyConvertedCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),

                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveMobileAppCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveDynamicTextCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(endedActiveCpmBannerCampaignId)
                                .withState(CampaignStateGetEnum.ENDED).getBean()
                ))
        );
    }
}
