package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateEnum;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsArchived;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCurrency;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsCurrencyconverted;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelfik on 01.03.17.
 * https://st.yandex-team.ru/DIRECT-53438
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-53438")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля States метода Get для кампании сконвертированной копированием")
public class GetStatesOfCopyConvertedCampaignTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @BeforeClass
    public static void createCampaign() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        CampaignsRecord campaigns =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampaignById(id);
        campaigns.setCurrency(CampaignsCurrency.YND_FIXED);
        campaigns.setArchived(CampaignsArchived.Yes);
        campaigns.setCurrencyconverted(CampaignsCurrencyconverted.Yes);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(campaigns);
    }

    @Test
    public void getIdWithoutSelectionCriteria() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                        )
                        .withFieldNames(CampaignFieldEnum.ID));
        CampaignGetItem campaign = getResponse.getCampaigns().stream()
                .filter(c -> c.getId().equals(id)).findAny().orElse(null);

        assertThat("кампания не вернулось",
                campaign, nullValue());
    }

    @Test
    public void getStateWithoutSelectionCriteria() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                        )
                        .withFieldNames(CampaignFieldEnum.STATE));
        List<CampaignGetItem> campaigns = getResponse.getCampaigns().stream()
                .filter(c -> CampaignStateGetEnum.CONVERTED.equals(c.getState())).collect(Collectors.toList());
        assertThat("не вернулось ни одной кампании со State = CONVERTED",
                campaigns, hasSize(0));
    }

    @Test
    public void getStatusClarificationWithoutSelectionCriteria() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                        )
                        .withFieldNames(CampaignFieldEnum.STATUS_CLARIFICATION));
        List<CampaignGetItem> campaigns = getResponse.getCampaigns().stream()
                .filter(c -> "Converted".equals(c.getStatusClarification())).collect(Collectors.toList());
        assertThat("не вернулось ни одной кампании со StatusClarification = \"Converted\"",
                campaigns, hasSize(0));
    }

    @Test
    public void getByIds() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE,
                                CampaignFieldEnum.STATUS_CLARIFICATION));
        assertThat("вернулись кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(id)
                                .withState(CampaignStateGetEnum.CONVERTED)
                                .withStatusClarification(StatusClarification.CONVERTED.getStatusClarification()).getBean()
                )));
    }

    @Test
    public void getByStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withStates(CampaignStateEnum.CONVERTED)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATE,
                                CampaignFieldEnum.STATUS_CLARIFICATION));
        assertThat("вернулись кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(id)
                                .withState(CampaignStateGetEnum.CONVERTED)
                                .withStatusClarification(StatusClarification.CONVERTED.getStatusClarification()).getBean()
                )));
    }
}
