package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.general.StatisticsMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 18.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля Statistics FiledNames")
@RunWith(Parameterized.class)
@Tag(TagDictionary.TRUNK)
public class GetStatisticsTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String login;

    @Parameterized.Parameter(2)
    public Long expectedClicks;

    @Parameterized.Parameter(3)
    public Long expectedImpressions;

    @Parameterized.Parameters(name = "{0}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {"get statistics with only impressions", client, 0L, 25L},
                {"get statistics with clicks and impressions", client, 35L, 60L},
                {"get statistics without clicks and impressions", client, 0L, 0L},
        };
        return Arrays.asList(data);
    }

    private Long id;

    @Before
    public void prepareData() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.as(login);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        campaignFakeInfo.setClicks(expectedClicks.intValue());
        campaignFakeInfo.setShows(expectedImpressions.intValue());
        api.userSteps.campaignFakeSteps().fakeCampaignParams(campaignFakeInfo);

    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("479")
    public void checkStatistics() {
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.STATISTICS
                );
        assertThat("вернулась правильная статистика", campaignGetItem,
                beanDifferV5((CampaignGetItem)
                        new CampaignGetItemMap()
                                .withStatistics(
                                        new StatisticsMap()
                                                .withClicks(expectedClicks)
                                                .withImpressions(expectedImpressions)
                                ).getBean()));
    }
}
