package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStatusPaymentEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля StatusPayment FiledNames для медийной кампании")
public class GetStatusPaymentOfCpmBannerCampaignTest {

    private static String client = CampaignsLogins.GET_CLIENT;
    private static String clientWithAccount = CampaignsLogins.GET_PROPERTY_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private CampaignGetItem campaignGetItem;
    private static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(clientWithAccount);
        id = api.as(client).userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultCpmBannerUserProfileAdGroup(id);
        Long creativeId = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).perfCreativesSteps()
                .saveDefaultCanvasCreativesForClient(Long.parseLong(User.get(client).getClientID()));
        adId = api.userSteps.adsSteps().addDefaultCpmBannerAdBuilderAd(adGroupId, creativeId);
    }

    @Test
    public void getByAllStatuses() {
        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id
                                        )
                                        .withStatusesPayment(
                                                CampaignStatusPaymentEnum.DISALLOWED,
                                                CampaignStatusPaymentEnum.ALLOWED
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT));
        assertThat("вернулась кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(id)
                                .withStatusPayment(
                                        CampaignStatusPaymentEnum.DISALLOWED).getBean()
                )));
    }

    @Test
    public void getDisallowedWithStatusModerateSent() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    public void getDisallowedWithStatusModerateReady() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.READY);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    public void getDisallowedWithStatusModerateNo() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    public void getDisallowedWithStatusModerateNew() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.NEW);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    public void getAllowedWithStatusModerateYes() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.YES);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.ALLOWED).getBean()));

    }

    @Test
    public void getStatusPaymentForDraftConnectedToWallet() {
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().enableSharedAccount(clientWithAccount);
        Long idConnectedToAccount =
                api.as(clientWithAccount).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        idConnectedToAccount,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(idConnectedToAccount)
                        .withStatusPayment(CampaignStatusPaymentEnum.ALLOWED).getBean()));
    }
}
