package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStatusPaymentEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 23.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-44876")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля StatusPayment FiledNames для динамической текстовой кампании")
public class GetStatusPaymentOfDynamicTextCampaignTest {

    private static String client = CampaignsLogins.GET_CLIENT;
    private static String clientWithAccount = CampaignsLogins.GET_PROPERTY_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private CampaignGetItem campaignGetItem;
    private static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(clientWithAccount);
        id = api.as(client).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroupDynamic(id);
        adId = api.userSteps.adsSteps().addDefaultDynamicTextAd(adGroupId);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("489")
    public void getByAllStatuses() {
        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id
                                        )
                                        .withStatusesPayment(
                                                CampaignStatusPaymentEnum.DISALLOWED,
                                                CampaignStatusPaymentEnum.ALLOWED
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT));
        assertThat("вернулись кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(id)
                                .withStatusPayment(
                                        CampaignStatusPaymentEnum.DISALLOWED).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("490")
    public void getDisallowedWithStatusModerateSent() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.SENT);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("491")
    public void getDisallowedWithStatusModerateReady() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.READY);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("492")
    public void getDisallowedWithStatusModerateNo() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.NO);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("493")
    public void getDisallowedWithStatusModerateNew() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.NEW);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.NO);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.DISALLOWED).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("494")
    public void getAllowedWithStatusModerateYes() {
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.YES);
        campaignGetItem =
                api.as(client).userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(id)
                        .withStatusPayment(CampaignStatusPaymentEnum.ALLOWED).getBean()));

    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("495")
    public void getStatusPaymentForDraftConnectedToWallet() {
        //DIRECT-46020
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().enableSharedAccount(clientWithAccount);
        Long idConnectedToAccount =
                api.as(clientWithAccount).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        idConnectedToAccount,
                        CampaignFieldEnum.ID, CampaignFieldEnum.STATUS_PAYMENT
                );
        assertThat("вернулся правильный StatusPayment", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withId(idConnectedToAccount)
                        .withStatusPayment(CampaignStatusPaymentEnum.ALLOWED).getBean()));
    }
}
