package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStatusSelectionEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.campaigns.Status;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@Features(CampaignsFeatures.GET)
@Description("Проверка логики поля Statuses SelectionCriteria метода Get для медийной кампании")
@RunWith(Parameterized.class)
public class GetStatusesOfCpmBannerCampaignTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Parameterized.Parameter(0)
    public String statusModeration;

    @Parameterized.Parameter(1)
    public CampaignStatusSelectionEnum[] inputStatus;

    @Parameterized.Parameter(2)
    public StatusEnum outputStatus;

    @Parameterized.Parameters(name = "statusModeration = {0}, status = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {
                        Status.NEW,
                        new CampaignStatusSelectionEnum[]{CampaignStatusSelectionEnum.DRAFT},
                        StatusEnum.DRAFT
                },
                {
                        Status.SENT,
                        new CampaignStatusSelectionEnum[]{CampaignStatusSelectionEnum.MODERATION},
                        StatusEnum.MODERATION
                },
                {
                        Status.READY,
                        new CampaignStatusSelectionEnum[]{CampaignStatusSelectionEnum.MODERATION},
                        StatusEnum.MODERATION
                },
                {
                        Status.YES,
                        new CampaignStatusSelectionEnum[]{CampaignStatusSelectionEnum.ACCEPTED},
                        StatusEnum.ACCEPTED
                },
                {
                        Status.NO,
                        new CampaignStatusSelectionEnum[]{CampaignStatusSelectionEnum.REJECTED},
                        StatusEnum.REJECTED
                },
                {
                        Status.NEW,
                        new CampaignStatusSelectionEnum[]{
                                CampaignStatusSelectionEnum.DRAFT,
                                CampaignStatusSelectionEnum.MODERATION,
                                CampaignStatusSelectionEnum.ACCEPTED,
                                CampaignStatusSelectionEnum.REJECTED
                        },
                        StatusEnum.DRAFT
                }

        };
        return Arrays.asList(data);
    }

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(id, statusModeration);
    }

    @Test
    public void getByStatus() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id
                                        )
                                        .withStatuses(
                                                inputStatus
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATUS));
        assertThat("вернулась кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanDifferV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(id)
                                .withStatus(outputStatus).getBean()
                )));
    }
}
