package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.PriorityGoalsArray;
import com.yandex.direct.api.v5.campaigns.PriorityGoalsItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.PriorityGoalsItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionCrrAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionCrrAddMap.DEFAULT_CRR;
import static ru.yandex.autotests.directapi.model.api5.campaigns.StrategyPayForConversionCrrAddMap.DEFAULT_WEEKLY_SPEND_LIMIT;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-151192")
@Features(CampaignsFeatures.GET)
@Description("Проверка выставления source для кц в зависимости от типа стратегии")
@Tag(TagDictionary.TRUNK)
public class GetTextCampaignWithMeaningfulGoalValueMetrikaSourceTest {
    private static final String LOGIN = CampaignsLogins.CLIENT;

    private static final Integer COUNTER_ID = MetrikaGoals.getCounterForLogin(LOGIN);
    private static final Long GOAL_ID = MetrikaGoals.getConterGoalIds(COUNTER_ID, 2)[0];
    private static final Long GOAL_ID_SECOND = MetrikaGoals.getConterGoalIds(COUNTER_ID, 2)[1];
    public static final long VALUE = 13_000_000L;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(LOGIN);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private int shard;
    private Long cid;

    @Before
    public void before() {
        shard = api.userSteps.clientFakeSteps().getUserShard(LOGIN);
        cid = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withCounterIds(COUNTER_ID)
                        .withPriorityGoals(new PriorityGoalsItemMap()
                                .withGoalId(GOAL_ID)
                                .withValue(VALUE),
                                new PriorityGoalsItemMap()
                                        .withGoalId(GOAL_ID_SECOND)
                                        .withValue(VALUE)
                        )
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION_CRR)
                                        .withPayForConversionCrr(new StrategyPayForConversionCrrAddMap()
                                                .withGoalId(GOAL_ID)
                                                .withCrr(DEFAULT_CRR)
                                                .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT)
                                        )
                                )
                                .withNetwork(new TextCampaignNetworkStrategyAddMap().defaultServingOff())
                        )
                )
        );
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(LOGIN).campaignsSteps()
                .setCampaignMeaningfulGoals(cid,
                        "[{\"value\": \"13.00\", \"goal_id\": " + GOAL_ID + ", \"is_metrika_source_of_value\": true}, " +
                                "{\"value\": \"13.00\", \"goal_id\": " + GOAL_ID_SECOND + ", \"is_metrika_source_of_value\": false}]");
    }

    @Test
    public void getCampaignWithSourceOfMeaningfulGoalsValue() {
        CampaignGetItem campaign = api.userSteps.campaignSteps().getCampaign(cid);
        List<PriorityGoalsItem> priorityGoals= campaign.getTextCampaign().getPriorityGoals().getValue().getItems();

        PriorityGoalsItem expectedGoalFirst = new PriorityGoalsItem();
        expectedGoalFirst.setGoalId(GOAL_ID);
        expectedGoalFirst.setValue(VALUE);
        expectedGoalFirst.setIsMetrikaSourceOfValue(YesNoEnum.YES);

        PriorityGoalsItem expectedGoalSecond = new PriorityGoalsItem();
        expectedGoalSecond.setGoalId(GOAL_ID_SECOND);
        expectedGoalSecond.setValue(VALUE);
        expectedGoalSecond.setIsMetrikaSourceOfValue(YesNoEnum.NO);

        List<PriorityGoalsItem> expectedPriorityGoals = asList(expectedGoalFirst, expectedGoalSecond);
        assertThat("Кц соответствуют ожиданиям", priorityGoals, beanDifferV5(expectedPriorityGoals));
    }

}
