package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignTypeEnum;
import com.yandex.direct.api.v5.campaigns.CampaignTypeGetEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanEquivalentV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 22.07.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка фильтрации по Types")
@Tag(TagDictionary.TRUNK)
public class GetTypesTest {
    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);
    private static Long textId;
    private static Long mobileAppId;
    private static Long dynamicTextId;
    private static Long cpmBannerId;
    private GetResponse getResponse;

    @BeforeClass
    public static void createCampaigns() {
        textId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        mobileAppId = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        dynamicTextId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        cpmBannerId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("517")
    public void getByMobileType() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                buildSelectionCriteria(
                                        CampaignTypeEnum.MOBILE_APP_CAMPAIGN)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        assertThat("вернулась кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanEquivalentV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(mobileAppId)
                                .withType(CampaignTypeGetEnum.MOBILE_APP_CAMPAIGN).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("518")
    public void getByTextType() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                buildSelectionCriteria(
                                        CampaignTypeEnum.TEXT_CAMPAIGN)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        assertThat("вернулась кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanEquivalentV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(textId)
                                .withType(CampaignTypeGetEnum.TEXT_CAMPAIGN).getBean()
                )));
    }

    @Test
    public void getByCpmBannerType() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                buildSelectionCriteria(
                                        CampaignTypeEnum.CPM_BANNER_CAMPAIGN)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE));
        assumeThat("вернулась 1 кампания", getResponse.getCampaigns(), hasSize(1));
        assertThat("вернулась кампания ожидаемого типа",
                getResponse.getCampaigns(),
                beanEquivalentV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(cpmBannerId)
                                .withType(CampaignTypeGetEnum.CPM_BANNER_CAMPAIGN).getBean()
                )));
    }

    @Test
    public void getByCmpBannerAndTextType() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                buildSelectionCriteria(
                                        CampaignTypeEnum.TEXT_CAMPAIGN,
                                        CampaignTypeEnum.CPM_BANNER_CAMPAIGN)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE));
        assumeThat("вернулись 2 кампании", getResponse.getCampaigns(), hasSize(2));
        assertThat("вернулись ожидаемые кампании",
                getResponse.getCampaigns(),
                beanEquivalentV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(textId)
                                .withType(CampaignTypeGetEnum.TEXT_CAMPAIGN).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(cpmBannerId)
                                .withType(CampaignTypeGetEnum.CPM_BANNER_CAMPAIGN).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("514")
    public void getByTextAndMobileTypes() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                buildSelectionCriteria(
                                        CampaignTypeEnum.TEXT_CAMPAIGN,
                                        CampaignTypeEnum.MOBILE_APP_CAMPAIGN)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE));
        assumeThat("вернулись 2 кампании", getResponse.getCampaigns(), hasSize(2));
        assertThat("вернулись ожидаемые кампании",
                getResponse.getCampaigns(),
                beanEquivalentV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(textId)
                                .withType(CampaignTypeGetEnum.TEXT_CAMPAIGN).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(mobileAppId)
                                .withType(CampaignTypeGetEnum.MOBILE_APP_CAMPAIGN).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("515")
    public void getByTextAndDynamicTextTypes() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                buildSelectionCriteria(
                                        CampaignTypeEnum.TEXT_CAMPAIGN,
                                        CampaignTypeEnum.DYNAMIC_TEXT_CAMPAIGN)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE));
        assumeThat("вернулись 2 кампании", getResponse.getCampaigns(), hasSize(2));
        assertThat("вернулись ожидаемые кампании",
                getResponse.getCampaigns(),
                beanEquivalentV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(textId)
                                .withType(CampaignTypeGetEnum.TEXT_CAMPAIGN).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(dynamicTextId)
                                .withType(CampaignTypeGetEnum.DYNAMIC_TEXT_CAMPAIGN).getBean()
                )));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("516")
    public void getByAllTypes() {
        getResponse = api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                buildSelectionCriteria(
                                        CampaignTypeEnum.TEXT_CAMPAIGN,
                                        CampaignTypeEnum.MOBILE_APP_CAMPAIGN,
                                        CampaignTypeEnum.DYNAMIC_TEXT_CAMPAIGN,
                                        CampaignTypeEnum.CPM_BANNER_CAMPAIGN)
                        )
                        .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.TYPE));
        assumeThat("вернулись 4 кампании", getResponse.getCampaigns(), hasSize(4));
        assertThat("вернулись ожидаемые кампании",
                getResponse.getCampaigns(),
                beanEquivalentV5(Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(textId)
                                .withType(CampaignTypeGetEnum.TEXT_CAMPAIGN).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(mobileAppId)
                                .withType(CampaignTypeGetEnum.MOBILE_APP_CAMPAIGN).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(dynamicTextId)
                                .withType(CampaignTypeGetEnum.DYNAMIC_TEXT_CAMPAIGN).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap()
                                .withId(cpmBannerId)
                                .withType(CampaignTypeGetEnum.CPM_BANNER_CAMPAIGN).getBean()
                )));
    }

    private CampaignsSelectionCriteriaMap buildSelectionCriteria(CampaignTypeEnum... types) {
        return new CampaignsSelectionCriteriaMap()
                .withIds(
                        textId,
                        mobileAppId,
                        dynamicTextId,
                        cpmBannerId
                ).withTypes(types);
    }
}
