package ru.yandex.autotests.direct.api.campaigns.get;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 25.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка списания баллов.")
public class GetUnitsTest {

    private static final int GET_CALL_COST = 10;
    private static final int GET_CAMPAIGN_COST = 1;
    private static final int ERROR_COST = 20;
    private static final int COMMON_ERROR_COST = 50;

    private static final String PARAMS = "params";

    private static String client = CampaignsLogins.GET_UNITS_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id1;
    private static Long id2;

    @BeforeClass
    public static void createCampaign() {
        id1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        id2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Before
    public void refreshUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("519")
    public void getOneCampaign() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().campaignsGet(
                id1,
                CampaignFieldEnum.ID
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_CALL_COST + GET_CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("520")
    public void getTwoSameCampaign() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id1,
                                                id1
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_CALL_COST + GET_CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("521")
    public void getTwoCampaign() {
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().campaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id1,
                                                id2
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(GET_CALL_COST + 2 * GET_CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("522")
    public void getWithRequestError() {
        //DIRECT-45515
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(id1)),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        PARAMS, capitalize(GetRequestMap.FIELD_NAMES)));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(COMMON_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("523")
    public void getWithObjectError() {
        //DIRECT-45515
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id2
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withPage(
                                new LimitOffsetMap()
                                        .withOffset(-1L)),
                new Api5Error(4002, Api5ErrorDetails.OFFSET_MUST_BE_MORE_OR_EQUAL_THAN_0));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(ERROR_COST + GET_CALL_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("524")
    public void getWithoutUnits() {
        int units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(client, units);
        units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assumeThat("у клиента не осталось баллов", units, equalTo(0));
        api.userSteps.campaignSteps().expectErrorOnCampaignsGet(
                new GetRequestMap()
                        .withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(
                                                id1,
                                                id2
                                        )
                        )
                        .withFieldNames(CampaignFieldEnum.ID),
                client,
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION)
        );
    }
}
