package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 08.09.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + States)")
@Tag(TagDictionary.TRUNK)
public class IdsWithStatesFilterTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long onCampaign;
    static Long offCampaign;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        onCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign();
        offCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusActive(onCampaign, Status.YES);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("529")
    public void getCampaignAndOtherState() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(onCampaign)
                        .withStates(CampaignStateEnum.OFF))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("не вернулось ни одной кампании", getResponse.getCampaigns(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("530")
    public void getCampaignAndTwoStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(onCampaign)
                        .withStates(CampaignStateEnum.ON, CampaignStateEnum.OFF))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(onCampaign).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("531")
    public void getTwoCampaignsAndState() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(onCampaign, offCampaign)
                        .withStates(CampaignStateEnum.ON))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(onCampaign).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("532")
    public void getTwoCampaignsAndTwoStates() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(onCampaign, offCampaign)
                        .withStates(CampaignStateEnum.ON, CampaignStateEnum.OFF))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap().withId(onCampaign).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap().withId(offCampaign).getBean())));
    }
}
