package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStatusSelectionEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 08.09.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + Statuses)")
public class IdsWithStatusesFilterTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long draftCampaign;
    static Long moderationCampaign;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        draftCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign();
        moderationCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(moderationCampaign, Status.SENT);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("533")
    public void getCampaignAndOtherStatus() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(draftCampaign)
                        .withStatuses(CampaignStatusSelectionEnum.MODERATION))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("не вернулось ни одной кампании", getResponse.getCampaigns(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("534")
    public void getCampaignAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(draftCampaign)
                        .withStatuses(CampaignStatusSelectionEnum.DRAFT, CampaignStatusSelectionEnum.MODERATION))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(draftCampaign).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("535")
    public void getTwoCampaignsAndStatus() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(draftCampaign, moderationCampaign)
                        .withStatuses(CampaignStatusSelectionEnum.DRAFT))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(draftCampaign).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("536")
    public void getTwoCampaignsAndTwoStatuses() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(draftCampaign, moderationCampaign)
                        .withStatuses(CampaignStatusSelectionEnum.DRAFT, CampaignStatusSelectionEnum.MODERATION))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap().withId(draftCampaign).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap().withId(moderationCampaign).getBean())));
    }
}
