package ru.yandex.autotests.direct.api.campaigns.get;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStatusPaymentEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanDiffer;

/**
 * Created by pavryabov on 13.09.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка фильтрации при использовании нескольких критериев (Ids + StatusesPayment)")
@Tag(TagDictionary.TRUNK)
public class IdsWithStatusesPaymentFilterTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    static Long allowedCampaign;
    static Long disallowedCampaign;

    @BeforeClass
    public static void initTest() {
        api.as(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        allowedCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(allowedCampaign);
        Long adId = api.userSteps.adsSteps().addDefaultTextAd(adGroupId);
        disallowedCampaign = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(allowedCampaign, Status.YES);
        api.userSteps.bannersFakeSteps().setStatusModerate(adId, Status.YES);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("538")
    public void getCampaignAndOtherStatusPayment() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(allowedCampaign)
                        .withStatusesPayment(CampaignStatusPaymentEnum.DISALLOWED))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("не вернулось ни одной кампании", getResponse.getCampaigns(), hasSize(0));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("539")
    public void getCampaignAndTwoStatusesPayment() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(allowedCampaign)
                        .withStatusesPayment(CampaignStatusPaymentEnum.ALLOWED, CampaignStatusPaymentEnum.DISALLOWED))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(allowedCampaign).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("540")
    public void getTwoCampaignsAndStatusPayment() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(allowedCampaign, disallowedCampaign)
                        .withStatusesPayment(CampaignStatusPaymentEnum.ALLOWED))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList((CampaignGetItem) new CampaignGetItemMap()
                        .withId(allowedCampaign).getBean())));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("537")
    public void getTwoCampaignssAndTwoStatusesPayment() {
        GetResponse getResponse = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(allowedCampaign, disallowedCampaign)
                        .withStatusesPayment(CampaignStatusPaymentEnum.ALLOWED, CampaignStatusPaymentEnum.DISALLOWED))
                .withFieldNames(CampaignFieldEnum.ID));
        assertThat("вернулся правильный ответ", getResponse.getCampaigns(), beanDiffer(
                Arrays.asList(
                        (CampaignGetItem) new CampaignGetItemMap().withId(allowedCampaign).getBean(),
                        (CampaignGetItem) new CampaignGetItemMap().withId(disallowedCampaign).getBean())));
    }
}
