package ru.yandex.autotests.direct.api.campaigns.get.contentpromotion;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.ContentPromotionCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaignsext.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.beans.campaign.StrategyData;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStrategyName;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaignsext.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaignsext.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelgik on 24.07.17.
 * https://st.yandex-team.ru/DIRECT-67833
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-67833")
@Features(CampaignsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка возможности получить стратегию на поиск")
public class GetSearchStrategy {
    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static DirectJooqDbSteps jooqDbSteps;

    @BeforeClass
    public static void createCampaign() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        campaignId = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
    }

    @Test
    public void checkSearchStrategy() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);

        CampaignsRecord campaignsRecord = new CampaignsRecord();
        campaignsRecord.setCid(campaignId);
        campaignsRecord.setStrategyName(CampaignsStrategyName.autobudget_avg_click);
        campaignsRecord.setStrategyData(new StrategyData()
                .withName(CampaignsStrategyName.autobudget_avg_click)
                .withSum(300.0)
                .withAvgBid(0.9)
                .withVersion(1)
                .toJsonElement());
        jooqDbSteps.useShard(shard).campaignsSteps().updateCampaigns(campaignsRecord);

        GetResponse getResponse = api.as(client).userSteps.campExtSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withContentPromotionCampaignFieldNames(ContentPromotionCampaignFieldEnum.BIDDING_STRATEGY));
        CampaignGetItem campaign = getResponse.getCampaigns().get(0);
        ContentPromotionCampaignSearchStrategyTypeEnum searchStrategy = campaign.getContentPromotionCampaign()
                .getBiddingStrategy().getSearch().getBiddingStrategyType();
        assertThat("получили нужную стратегию", searchStrategy,
                equalTo(ContentPromotionCampaignSearchStrategyTypeEnum.AVERAGE_CPC));
    }
}
