package ru.yandex.autotests.direct.api.campaigns.get.cpmbannercampaign;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

public class GetCounterIdsTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Test
    public void checkCounterIdsNotSet() {
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();

        assertThat("Поле CounterIds установлено правильно", getCounterIds(), nullValue());
    }

    @Test
    public void checkCounterIdsFieldIsSet() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withCpmBannerCampaign(
                        new CpmBannerCampaignAddItemMap()
                                .defaultCpmBannerCampaign()
                                .withCounterIds(1, 2, 3)));

        assertThat("Поле CounterIds установлено правильно", getCounterIds().getItems(),
                is(asList(1, 2, 3)));
    }

    private ArrayOfInteger getCounterIds() {
        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum.COUNTER_IDS));

        assumeThat("Вернулась одна кампания", getResponse.getCampaigns(), hasSize(1));

        return getResponse.getCampaigns().get(0).getCpmBannerCampaign().getCounterIds().getValue();
    }
}
