package ru.yandex.autotests.direct.api.campaigns.get.cpmbannercampaign;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CpmBannerCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.joda.time.DateTime;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CpmBannerCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FrequencyCapSettingAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-83722")
@Features(CampaignsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка возможности получить ограничение частоты показов (FrequencyCap) в медийной кампании")
public class GetFrequencyCapTest {

    private static final int IMPRESSIONS = 11;
    private static final int PERIOD_DAYS = 8;

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Test
    public void noFrequencyCapIsSetTest() {
        campaignId = api.userSteps.campaignSteps().addDefaultCpmBannerCampaign();

        CampaignGetItem campaign = getCampaignItem();

        assertThat("Поле FrequencyCap имеет правильное значение",
                campaign.getCpmBannerCampaign().getFrequencyCap().getValue(), nullValue());
    }

    @Test
    public void bothFieldsAreSetTest() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap().defaultCampaignAddItem().withCpmBannerCampaign(
                        new CpmBannerCampaignAddItemMap().defaultCpmBannerCampaign()
                                .withFrequencyCap(new FrequencyCapSettingAddMap()
                                        .withImpressions(IMPRESSIONS)
                                        .withPeriodDays(PERIOD_DAYS))));

        CampaignGetItem campaign = getCampaignItem();

        assertThat("Поле Impressions имеет правильное значение",
                campaign.getCpmBannerCampaign().getFrequencyCap().getValue().getImpressions(), is(IMPRESSIONS));
        assertThat("Поле Period имеет правильное значение",
                campaign.getCpmBannerCampaign().getFrequencyCap().getValue().getPeriodDays(), is(PERIOD_DAYS));
    }

    @Test
    public void periodDaysFieldIsNull() {
        JsonObject request = new JsonObject()
                .with(capitalize(CampaignAddItemMap.NAME), "name")
                .with(capitalize(CampaignAddItemMap.START_DATE),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN))
                .with(capitalize(CampaignAddItemMap.CPM_BANNER_CAMPAIGN),
                        new JsonObject()
                                .with(capitalize(CpmBannerCampaignAddItemMap.BIDDING_STRATEGY),
                                        new CpmBannerCampaignStrategyAddMap()
                                                .defaultCpmBannerCampaignStrategy()
                                                .getBean())
                                .with(capitalize(CpmBannerCampaignAddItemMap.FREQUENCY_CAP),
                                        new JsonObject()
                                                .with(capitalize(FrequencyCapSettingAddMap.IMPRESSIONS), IMPRESSIONS)
                                                .with(capitalize(FrequencyCapSettingAddMap.PERIOD_DAYS), "null")));

        campaignId = api.userSteps.campaignSteps().addCampaign(new JsonObject().with(capitalize(AddRequestMap.CAMPAIGNS),
                new Object[] {request}));

        CampaignGetItem campaign = getCampaignItem();

        assertThat("Поле Impressions имеет правильное значение",
                campaign.getCpmBannerCampaign().getFrequencyCap().getValue().getImpressions(), is(IMPRESSIONS));
        assertThat("Поле Period имеет правильное значение",
                campaign.getCpmBannerCampaign().getFrequencyCap().getValue().getPeriodDays(), nullValue());
    }

    private CampaignGetItem getCampaignItem() {
        GetResponse response = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withCpmBannerCampaignFieldNames(CpmBannerCampaignFieldEnum.FREQUENCY_CAP));

        assumeThat("Вернулась 1 кампания", response.getCampaigns(), hasSize(1));

        return response.getCampaigns().get(0);
    }
}
