package ru.yandex.autotests.direct.api.campaigns.get.dynamictextcampaign;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampOptionsStrategy;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsPlatform;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.anyOf;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by lightelgik on 24.07.17.
 * https://st.yandex-team.ru/DIRECT-67833
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-67833")
@Features(CampaignsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка возможности получить стратегию на сети")
public class GetNetworkStrategy {
    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;
    private static DirectJooqDbSteps jooqDbSteps;

    @BeforeClass
    public static void createCampaign() {
        jooqDbSteps = api.userSteps.getDirectJooqDbSteps();
        campaignId = api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
    }

    @Test
    public void checkNetworkStrategy() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        jooqDbSteps.useShard(shard).campaignsSteps().updateCampOptions(
                new CampOptionsRecord()
                        .setCid(campaignId)
                        .setStrategy(CampOptionsStrategy.different_places));
        jooqDbSteps.useShard(shard).campaignsSteps().updateCampaigns(
                new CampaignsRecord()
                        .setCid(campaignId)
                        .setPlatform(CampaignsPlatform.context));

        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        CampaignGetItem campaign = getResponse.getCampaigns().get(0);
        DynamicTextCampaignNetworkStrategyTypeEnum networkStrategy = campaign.getDynamicTextCampaign()
                .getBiddingStrategy().getNetwork().getBiddingStrategyType();

        // после перехода API5 Campaigns.Get на java стратегии, кроме SERVING_OFF, перестали поддерживаться
        // TODO DIRECT-169007: убрать MAXIMUM_COVERAGE после переключения Campaigns.Get на Java
        assertThat("получили стратегию SERVING_OFF или MAXIMUM_COVERAGE", networkStrategy,
                anyOf(
                        equalTo(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF),
                        equalTo(DynamicTextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)
                ));
    }

    @Test
    public void checkNetworkStrategyWithParameters() {
        int shard = api.userSteps.clientFakeSteps().getUserShard(client);
        jooqDbSteps.useShard(shard).campaignsSteps().updateCampOptions(
                new CampOptionsRecord()
                        .setCid(campaignId)
                        .setStrategy(null));

        jooqDbSteps.useShard(shard).campaignsSteps().updateCampaigns(
                new CampaignsRecord()
                        .setCid(campaignId)
                        .setPlatform(CampaignsPlatform.context)
                        .setContextpricecoef(70)
                        .setContextlimit(60));

        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withDynamicTextCampaignFieldNames(DynamicTextCampaignFieldEnum.BIDDING_STRATEGY));
        CampaignGetItem campaign = getResponse.getCampaigns().get(0);
        DynamicTextCampaignNetworkStrategyTypeEnum networkStrategy = campaign.getDynamicTextCampaign()
                .getBiddingStrategy().getNetwork().getBiddingStrategyType();

        // после перехода API5 Campaigns.Get на java стратегии, кроме SERVING_OFF, перестали поддерживаться
        // TODO DIRECT-169007: убрать NETWORK_DEFAULT после переключения Campaigns.Get на Java
        assertThat("получили стратегию SERVING_OFF или NETWORK_DEFAULT", networkStrategy,
                anyOf(
                        equalTo(DynamicTextCampaignNetworkStrategyTypeEnum.SERVING_OFF),
                        equalTo(DynamicTextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                ));
    }
}
