package ru.yandex.autotests.direct.api.campaigns.get.finance;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignFundsEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SharedAccountFundsParamMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 26.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-34568"),
        @Issue("https://st.yandex-team.ru/DIRECT-45228")
})
@Features(CampaignsFeatures.GET)
@Description("Проверка значений по умолчанию поля Finance режим SHARED_ACCOUNT_FUNDS")
@Tag(TagDictionary.TRUNK)
public class GetDefaultValueOfAccountModeTest {

    public static String client = CampaignsLogins.GET_ACCOUNT_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.as(Logins.SUPER_LOGIN).userSteps.financeSteps().enableSharedAccount(client);
        id = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("544")
    public void getFinanceOfAccount() {
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.FUNDS
                );
        assertThat("вернулоль ожидаемое значение по умолчанию", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withFunds(
                                new FundsParamMap()
                                        .withMode(CampaignFundsEnum.SHARED_ACCOUNT_FUNDS)
                                        .withSharedAccountFunds(
                                                new SharedAccountFundsParamMap()
                                                        .withRefund(0L)
                                                        .withSpend(0L)
                                        )).getBean()));
    }
}
