package ru.yandex.autotests.direct.api.campaigns.get.finance;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignFundsEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignFundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FundsParamMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.directapi.steps.forecast.ApproximateNumbersMatchVariation;
import ru.yandex.autotests.irt.testutils.beandiffer.matchvariation.MatchVariation;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Issues;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 19.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issues({
        @Issue("https://st.yandex-team.ru/DIRECT-34568"),
        @Issue("https://st.yandex-team.ru/DIRECT-45228")
})
@Features(CampaignsFeatures.GET)
@Description("Проверка значений поля Finance для кампании, не подключенной к ОС")
@RunWith(Parameterized.class)
public class GetFinanceCampaignModeTest {

    public static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    // В перл-версии campaigns.get нестабильно работает округление
    // Пока Campaigns.Get не переключится на Java, суммы будут проверяться приблизительно
    // TODO DIRECT-169007: убрать приблизительное сравнение после переключения Campaigns.Get на Java
    public static MatchVariation variation = new ApproximateNumbersMatchVariation(1, 100, true);

    private static Long textId;
    private static Long mobileAppId;
    private static Long dynamicTextId;

    @Parameterized.Parameter(0)
    public Float sum;

    @Parameterized.Parameter(1)
    public Float sumSpent;

    @Parameterized.Parameters(name = "sum = {0}, sum_spent = {1}")
    public static Collection testData() {
        Object[][] data = new Object[][]{
                {0f, 1000f},
                {1000f, 0f},
                {1000f, 900f},
                {1000f, 500f},
                {500f, 1000f},
                {1000f, 1000f},
                {0f, 0f}
        };
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        textId = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(textId, Status.YES);
        api.userSteps.campaignFakeSteps().setStatusShow(textId, Value.NO);
        mobileAppId = api.as(client).userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(mobileAppId, Status.YES);
        api.userSteps.campaignFakeSteps().setStatusShow(mobileAppId, Value.NO);
        dynamicTextId = api.as(client).userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(dynamicTextId, Status.YES);
        api.userSteps.campaignFakeSteps().setStatusShow(dynamicTextId, Value.NO);
    }

    @Before
    public void prepareCampaign() {
        api.userSteps.campaignFakeSteps().setCampaignSum(textId, sum);
        api.userSteps.campaignFakeSteps().setSumSpent(textId, sumSpent);
        api.userSteps.campaignFakeSteps().setCampaignSum(mobileAppId, sum);
        api.userSteps.campaignFakeSteps().setSumSpent(mobileAppId, sumSpent);
        api.userSteps.campaignFakeSteps().setCampaignSum(dynamicTextId, sum);
        api.userSteps.campaignFakeSteps().setSumSpent(dynamicTextId, sumSpent);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("549")
    public void getFinanceOfTextCampaign() {
        //DIRECT-45228
        //DIRECT-46266
        Long expectedSum = Money.valueOf(sum, Currency.RUB).bidLong().longValueForSum();
        Long expectedBalance = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT().bidLong().longValueForSum();
        Long expectedSumAvailableForTransfer = expectedBalance;
        if (expectedSumAvailableForTransfer < 0) {
            expectedSumAvailableForTransfer = 0L;
        }
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        textId,
                        CampaignFieldEnum.FUNDS
                );
        CampaignGetItem expectedCampaignGetItem = (CampaignGetItem) new CampaignGetItemMap()
                .withFunds(
                        new FundsParamMap()
                                .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                .withCampaignFunds(
                                        new CampaignFundsParamMap()
                                                .withSum(expectedSum)
                                                .withBalance(expectedBalance)
                                                .withBalanceBonus(0L)
                                                .withSumAvailableForTransfer(expectedSumAvailableForTransfer)
                                )).getBean();
        assertThat("вернулось ожидаемое значение Finance", campaignGetItem,
                beanDifferV5(expectedCampaignGetItem).withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("550")
    public void getFinanceOfMobileAppCampaign() {
        //DIRECT-45228
        //DIRECT-46266
        Long expectedSum = Money.valueOf(sum, Currency.RUB).bidLong().longValueForSum();
        Long expectedBalance = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT().bidLong().longValueForSum();
        Long expectedSumAvailableForTransfer = expectedBalance;
        if (expectedSumAvailableForTransfer < 0) {
            expectedSumAvailableForTransfer = 0L;
        }
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        mobileAppId,
                        CampaignFieldEnum.FUNDS
                );
        CampaignGetItem expectedCampaignGetItem = (CampaignGetItem) new CampaignGetItemMap()
                .withFunds(
                        new FundsParamMap()
                                .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                .withCampaignFunds(
                                        new CampaignFundsParamMap()
                                                .withSum(expectedSum)
                                                .withBalance(expectedBalance)
                                                .withBalanceBonus(0L)
                                                .withSumAvailableForTransfer(expectedSumAvailableForTransfer)
                                )).getBean();
        assertThat("вернулось ожидаемое значение Finance", campaignGetItem,
                beanDifferV5(expectedCampaignGetItem).withVariation(variation));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("551")
    public void getFinanceOfDynamicTextCampaign() {
        //DIRECT-45228
        //DIRECT-46266
        Long expectedSum = Money.valueOf(sum, Currency.RUB).bidLong().longValueForSum();
        Long expectedBalance = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT().bidLong().longValueForSum();
        Long expectedSumAvailableForTransfer = expectedBalance;
        if (expectedSumAvailableForTransfer < 0) {
            expectedSumAvailableForTransfer = 0L;
        }
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        dynamicTextId,
                        CampaignFieldEnum.FUNDS
                );
        CampaignGetItem expectedCampaignGetItem = (CampaignGetItem) new CampaignGetItemMap()
                .withFunds(
                        new FundsParamMap()
                                .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                .withCampaignFunds(
                                        new CampaignFundsParamMap()
                                                .withSum(expectedSum)
                                                .withBalance(expectedBalance)
                                                .withBalanceBonus(0L)
                                                .withSumAvailableForTransfer(expectedSumAvailableForTransfer)
                                )).getBean();
        assertThat("вернулось ожидаемое значение Finance", campaignGetItem,
                beanDifferV5(expectedCampaignGetItem).withVariation(variation));
    }
}
