package ru.yandex.autotests.direct.api.campaigns.get.finance;

import java.sql.Date;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignFundsEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampOptionsRecord;
import ru.yandex.autotests.direct.utils.date.DBTimeConverter;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignFundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FundsParamMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 05.10.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка влияния camp_options.stopTime и EndDate на значение поля SumAvailableForTransfer")
public class InfluenceStopTimeAndEndDateToSumAvailableForTransferTest {

    public static String client = CampaignsLogins.GET_CLIENT;
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final Integer TIMEOUT_AFTER_STOP = 30;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private static Float sum = 3000f;
    private static Float sumSpent = 0f;
    private static int shard;

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(id, Value.YES);
        api.userSteps.campaignFakeSteps().setCampaignSum(id, sum);
        api.userSteps.campaignFakeSteps().setSumSpent(id, sumSpent);
        shard = api.userSteps.clientFakeSteps().getUserShard(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("552")
    public void getFinanceOfCampaignStoppedMoreThan30MinutesAgo() {
        api.userSteps.campaignFakeSteps().setStatusShow(id, Value.NO);

        final CampOptionsRecord campOptions =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(id);
        campOptions.setStoptime(DBTimeConverter.jodaToSql(
                DateTime.now().minusMinutes(TIMEOUT_AFTER_STOP + 1)));
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(campOptions);

        Long expectedSum = Money.valueOf(sum, Currency.RUB).bidLong().longValue();
        Long expectedBalance = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT().bidLong().longValue();
        Long expectedSumAvailableForTransfer = expectedBalance;
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.FUNDS
                );
        assertThat("вернулоль ожидаемое значение Finance", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withFunds(
                                new FundsParamMap()
                                        .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                        .withCampaignFunds(
                                                new CampaignFundsParamMap()
                                                        .withSum(expectedSum)
                                                        .withBalance(expectedBalance)
                                                        .withBalanceBonus(0L)
                                                        .withSumAvailableForTransfer(expectedSumAvailableForTransfer)
                                        )).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("553")
    public void getFinanceOfCampaignStoppedLessThan30MinutesAgo() {
        api.userSteps.campaignFakeSteps().setStatusShow(id, Value.NO);

        final CampOptionsRecord campOptions =
                api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().getCampOptionsById(id);
        campOptions.setStoptime(
                DBTimeConverter.jodaToSql(
                        DateTime.now().minusMinutes(TIMEOUT_AFTER_STOP - 1)));
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampOptions(campOptions);

        Long expectedSum = Money.valueOf(sum, Currency.RUB).bidLong().longValue();
        Long expectedBalance = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT().bidLong().longValue();
        Long expectedSumAvailableForTransfer = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT()
                .subtract(MoneyCurrency.get(Currency.RUB).getMinTransferAmount()).bidLong().longValue();
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.FUNDS
                );
        assertThat("вернулось ожидаемое значение Finance", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withFunds(
                                new FundsParamMap()
                                        .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                        .withCampaignFunds(
                                                new CampaignFundsParamMap()
                                                        .withSum(expectedSum)
                                                        .withBalance(expectedBalance)
                                                        .withBalanceBonus(0L)
                                                        .withSumAvailableForTransfer(expectedSumAvailableForTransfer)
                                        )).getBean()));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("554")
    public void getFinanceOfCampaignFinishedDayAgo() {
        api.userSteps.campaignFakeSteps().setStatusShow(id, Value.YES);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .setFinishTime(id, Date.valueOf(DateTime.now().minusDays(1).toLocalDate().toString()));
        Long expectedSum = Money.valueOf(sum, Currency.RUB).bidLong().longValue();
        Long expectedBalance = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT().bidLong().longValue();
        Long expectedSumAvailableForTransfer = expectedBalance;
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.FUNDS
                );
        assertThat("вернулоль ожидаемое значение Finance", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withFunds(
                                new FundsParamMap()
                                        .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                        .withCampaignFunds(
                                                new CampaignFundsParamMap()
                                                        .withSum(expectedSum)
                                                        .withBalance(expectedBalance)
                                                        .withBalanceBonus(0L)
                                                        .withSumAvailableForTransfer(expectedSumAvailableForTransfer)
                                        )).getBean()));
    }
}
