package ru.yandex.autotests.direct.api.campaigns.get.finance;

import java.util.Arrays;
import java.util.Collection;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignFundsEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.Money;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignFundsParamMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignGetItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.FundsParamMap;
import ru.yandex.autotests.directapi.model.common.Value;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by pavryabov on 22.09.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка поля SumAvailableForTransfer")
@RunWith(Parameterized.class)
public class SumAvailableForTransferTest {

    public static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @Parameterized.Parameter(0)
    public Float sum;

    @Parameterized.Parameter(1)
    public Float sumSpent;

    @Parameterized.Parameter(2)
    public String statusModerate;

    @Parameterized.Parameter(3)
    public String statusShow;

    @Parameterized.Parameter(4)
    public Long expectedSumAvailableForTransfer;

    @Parameterized.Parameters(name = "sum = {0}, sum_spent = {1}, statusModerate = {2}, statusShow={3}")
    public static Collection testData() {
        Float startSum = 3000f;
        Float spentSum = 0f;
        Object[][] data = new Object[][]{
                {startSum, spentSum, Status.NEW, Value.NO, 0L},
                {startSum, spentSum, Status.NEW, Value.YES, 0L},
                {startSum, spentSum, Status.YES, Value.NO,
                        Money.valueOf(startSum - spentSum, Currency.RUB).subtractVAT().bidLong().longValue()},
                //блокируется сумма минимального переноса. Остальное можно перенести
                {startSum, spentSum, Status.YES, Value.YES,
                        Money.valueOf(startSum - spentSum, Currency.RUB).subtractVAT()
                                .subtract(MoneyCurrency.get(Currency.RUB)
                                        .getMinTransferAmount()).bidLong().longValue()},
                //если остаток (после блокировки) меньше минимальной суммы переноса, то нельзя перенести ничего.
                //Перенос суммы, меньшей, чем минимальная сумма переноса, возможен только с остановленной кампании
                {startSum, 2281f, Status.YES, Value.YES, 0L},
                {startSum, 2700f, Status.YES, Value.YES, 0L},
        };
        return Arrays.asList(data);
    }

    @Before
    public void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.as(client).userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignFakeSteps().setStatusModerate(id, statusModerate);
        api.userSteps.campaignFakeSteps().setStatusShow(id, statusShow);
        api.userSteps.campaignFakeSteps().setCampaignSum(id, sum);
        api.userSteps.campaignFakeSteps().setSumSpent(id, sumSpent);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("555")
    public void getFinanceOfCampaign() {
        Long expectedSum = Money.valueOf(sum, Currency.RUB).bidLong().longValue();
        Long expectedBalance = Money.valueOf(sum - sumSpent, Currency.RUB).subtractVAT().bidLong().longValue();
        CampaignGetItem campaignGetItem =
                api.userSteps.campaignSteps().campaignsGet(
                        id,
                        CampaignFieldEnum.FUNDS
                );
        assertThat("вернулоль ожидаемое значение Finance", campaignGetItem, beanDifferV5(
                (CampaignGetItem) new CampaignGetItemMap()
                        .withFunds(
                                new FundsParamMap()
                                        .withMode(CampaignFundsEnum.CAMPAIGN_FUNDS)
                                        .withCampaignFunds(
                                                new CampaignFundsParamMap()
                                                        .withSum(expectedSum)
                                                        .withBalance(expectedBalance)
                                                        .withBalanceBonus(0L)
                                                        .withSumAvailableForTransfer(expectedSumAvailableForTransfer)
                                        )).getBean()));
    }
}
