package ru.yandex.autotests.direct.api.campaigns.get.mobilecampaign;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSettingGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by ginger on 26.08.15.
 * https://st.yandex-team.ru/TESTIRT-6407
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34568")
@Features(CampaignsFeatures.GET)
@Description("Проверка проверка значения по умолчанию поля Settings для кампании РМП")
@Tag(TagDictionary.TRUNK)
public class GetDefaultValueOfSettingsTest {
    private static final String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.as(client).userSteps.campaignSteps().addDefaultMobileAppCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("556")
    public void defaultCampaignSettingsTest() {
        //DIRECT-46683
        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<MobileAppCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getMobileAppCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        List<Object> expectedSettings = Arrays.asList(
                new MobileAppCampaignSettingGetMap()
                        .withOption(MobileAppCampaignSettingsGetEnum.ADD_TO_FAVORITES)
                        .withValue(YesNoEnum.NO).getBean(),
                new MobileAppCampaignSettingGetMap()
                        .withOption(MobileAppCampaignSettingsGetEnum.CAMPAIGN_EXACT_PHRASE_MATCHING_ENABLED)
                        .withValue(YesNoEnum.NO).getBean(),
                new MobileAppCampaignSettingGetMap()
                        .withOption(MobileAppCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED)
                        .withValue(YesNoEnum.YES).getBean(),
                new MobileAppCampaignSettingGetMap()
                        .withOption(MobileAppCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                        .withValue(YesNoEnum.YES).getBean(),
                new MobileAppCampaignSettingGetMap()
                        .withOption(MobileAppCampaignSettingsGetEnum.MAINTAIN_NETWORK_CPC)
                        .withValue(YesNoEnum.YES).getBean(),
                new MobileAppCampaignSettingGetMap()
                        .withOption(MobileAppCampaignSettingsGetEnum.REQUIRE_SERVICING)
                        .withValue(YesNoEnum.NO).getBean(),
                //DIRECT-46739
                new MobileAppCampaignSettingGetMap()
                        .withOption(MobileAppCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED)
                        .withValue(YesNoEnum.NO).getBean());

        // TODO DIRECT-169007: после переключения campaigns.get на java сортировку можно будет убрать
        settings.sort(Comparator.comparing(x -> x.getOption().value()));
        assertThat("корректный набор настроек по умолчанию", settings,
                beanDifferV5(expectedSettings)
        );
    }
}
