package ru.yandex.autotests.direct.api.campaigns.get.mobilecampaign;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 01.03.2019.
 */
@Aqua.Test
@Features(CampaignsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-92407")
@RunWith(Parameterized.class)
@Description("Проверка получения параметров LimitPercent и BidPercent для стратегии NetworkDefault")
public class StrategyNetworkDefaultTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private Long campaignId;

    private static final MobileAppCampaignNetworkStrategy expectedContextStrategyWithParams = (MobileAppCampaignNetworkStrategy) new MobileAppCampaignNetworkStrategyMap()
            .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
            .withNetworkDefault(new StrategyNetworkDefaultMap()
                    .withLimitPercent(100)).getBean();
    private static final MobileAppCampaignNetworkStrategy expectedContextStrategyWithoutParams = (MobileAppCampaignNetworkStrategy) new MobileAppCampaignNetworkStrategyMap()
            .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT).getBean();
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchStrategyDescription;

    @Parameterized.Parameter(value = 1)
    public MobileAppCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public MobileAppCampaignNetworkStrategy expectedNetworkStrategy;

    @Parameterized.Parameter(value = 3)
    public Boolean hasSetting;

    @Parameterized.Parameters(name = "search = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                { "AverageCpc",
                        new MobileAppCampaignSearchStrategyAddMap().defaultAverageCpc(currency),
                        expectedContextStrategyWithoutParams,
                        true
                },
                { "WbMaximumClicks",
                        new MobileAppCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        expectedContextStrategyWithoutParams,
                        true
                },
                { "WbMaximumAppInstalls",
                        new MobileAppCampaignSearchStrategyAddMap().defaultWbMaximumAppInstalls(currency),
                        expectedContextStrategyWithoutParams,
                        true
                },
                { "AverageCpi",
                        new MobileAppCampaignSearchStrategyAddMap().defaultAverageCpi(currency),
                        expectedContextStrategyWithoutParams,
                        true
                },

        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withMobileAppCampaign(new MobileAppCampaignAddItemMap()
                        .withBiddingStrategy(new MobileAppCampaignStrategyAddMap()
                                .withSearch(searchStrategy)
                                .withNetwork(new MobileAppCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(MobileAppCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                                        .withNetworkDefault(new StrategyNetworkDefaultAddMap()
                                                .withLimitPercent(StrategyNetworkDefaultAddMap.DEFAULT_LIMIT_PERCENT))
                                )
                        )

                ));
    }

    @Test
    public void getNetworkDefaultTest() {
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withMobileAppCampaignFieldNames(MobileAppCampaignFieldEnum.BIDDING_STRATEGY, MobileAppCampaignFieldEnum.SETTINGS));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        MobileAppCampaignStrategy actualStrategy = campaigns.get(0).getMobileAppCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректную стратегию в сети", actualStrategy.getNetwork(),
                beanDifferV5(expectedNetworkStrategy));

        List<MobileAppCampaignSettingGet> settings = campaigns.get(0).getMobileAppCampaign().getSettings().stream()
                .filter(x -> (x.getOption().equals(MobileAppCampaignSettingsGetEnum.MAINTAIN_NETWORK_CPC)))
                .collect(Collectors.toList());
        assertThat("получили настройку MAINTAIN_NETWORK_CPC", !settings.isEmpty(),
                equalTo(hasSetting));
    }
}
