package ru.yandex.autotests.direct.api.campaigns.get.smartcampaign;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.SmartCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.SmartCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmartCampaignSettingGetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-109983")
@Features(CampaignsFeatures.GET)
@Tag(TagDictionary.TRUNK)
@Description("Проверка проверка значения по умолчанию поля Settings для смарт кампании")
public class GetDefaultValueOfSettingsTest {
    private static final String client = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();
    private static Long campaignId;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void createCampaign() {
        campaignId = api.as(client).userSteps.campaignSteps().addDefaultSmartCampaign(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("542")
    public void defaultCampaignSettingsTest() {
        GetResponse getResponse = api.as(client).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                                new CampaignsSelectionCriteriaMap()
                                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withSmartCampaignFieldNames(SmartCampaignFieldEnum.SETTINGS));
        assumeThat("получили созданную кампанию", getResponse.getCampaigns(), hasSize(1));
        List<SmartCampaignSettingGet> settings =
                getResponse.getCampaigns().get(0).getSmartCampaign().getSettings();
        assumeThat("получили настройки кампании", settings, notNullValue());

        List<Object> expectedSettings = Arrays.asList(
                new SmartCampaignSettingGetMap()
                        .withOption(SmartCampaignSettingsGetEnum.ADD_TO_FAVORITES)
                        .withValue(YesNoEnum.NO).getBean(),
                new SmartCampaignSettingGetMap()
                        .withOption(SmartCampaignSettingsGetEnum.DAILY_BUDGET_ALLOWED)
                        .withValue(YesNoEnum.YES).getBean(),
                new SmartCampaignSettingGetMap()
                        .withOption(SmartCampaignSettingsGetEnum.ENABLE_AREA_OF_INTEREST_TARGETING)
                        .withValue(YesNoEnum.YES).getBean(),
                new SmartCampaignSettingGetMap()
                        .withOption(SmartCampaignSettingsGetEnum.REQUIRE_SERVICING)
                        .withValue(YesNoEnum.NO).getBean(),
                //DIRECT-46739
                new SmartCampaignSettingGetMap()
                        .withOption(SmartCampaignSettingsGetEnum.SHARED_ACCOUNT_ENABLED)
                        .withValue(YesNoEnum.NO).getBean());

        // TODO DIRECT-169007: после переключения campaigns.get на java сортировку можно будет убрать
        settings.sort(Comparator.comparing(x -> x.getOption().value()));
        assertThat("корректный набор настроек по умолчанию", settings,
                beanDifferV5(expectedSettings)
        );
    }
}
