package ru.yandex.autotests.direct.api.campaigns.get.textcampaign;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.general.AttributionModelEnum;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.core.IsNull.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;


/**
 * Created by pavryabov on 18.11.15.
 * https://st.yandex-team.ru/TESTIRT-7756
 */
@Aqua.Test
@Features(CampaignsFeatures.GET)
@Description("Получение модели атрибуции при незаданном значении в БД")
@Issue("https://st.yandex-team.ru/DIRECT-44876")
public class GetCampaignNullAttributionModelTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignId;

    @Before
    public void prepare() {
        campaignId = api.userSteps.campaignSteps().addCampaign(
                new CampaignAddItemMap()
                        .defaultCampaignAddItem()
                        .withTextCampaign(new TextCampaignAddItemMap()
                                .defaultTextCampaign()));

        int shard = api.userSteps.clientFakeSteps().getUserShard(CLIENT);
        CampaignsRecord campaignsRecord = api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps()
                .getCampaignById(campaignId);
        api.userSteps.getDirectJooqDbSteps().useShard(shard).campaignsSteps().updateCampaigns(
                campaignsRecord.setAttributionModel(null)
        );
    }


    @Test
    public void checkGetAttrubutionModleForNullDbValue() {

        GetResponse getResponse = api.as(CLIENT).userSteps.campaignSteps().campaignsGet(
                new GetRequestMap().withSelectionCriteria(
                        new CampaignsSelectionCriteriaMap()
                                .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.ATTRIBUTION_MODEL));

        AttributionModelEnum attributionModel =
                getResponse.getCampaigns().get(0).getTextCampaign().getAttributionModel();
        assumeThat("получили attributionModel", attributionModel, notNullValue());

        assertThat("модель атрибуции соответствует ожиданиям", attributionModel,
                equalTo(AttributionModelEnum.LYDCCD));
    }
}


