package ru.yandex.autotests.direct.api.campaigns.get.textcampaign;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategy;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingGet;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsGetEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategy;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.StrategyNetworkDefaultMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.campaigns.MetrikaGoals;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.matchers.beans.version5.BeanDifferMatcherV5.beanDifferV5;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by gerdler on 01.03.2019.
 */
@Aqua.Test
@Features(CampaignsFeatures.GET)
@Issue("https://st.yandex-team.ru/DIRECT-92407")
@RunWith(Parameterized.class)
@Description("Проверка получения параметров LimitPercent и BidPercent для стратегии NetworkDefault")
public class StrategyNetworkDefaultTest {
    private static final String client = CampaignsLogins.CLIENT;
    private static final Currency currency = Currency.RUB;
    private static final Integer counterId = MetrikaGoals.getCounterForLogin(client);
    private static final Long goalId = MetrikaGoals.getGoalForCounter(counterId);
    private Long campaignId;

    private static final TextCampaignNetworkStrategyMap expectedContextStrategyMapWithParams =
            new TextCampaignNetworkStrategyMap()
                    .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                    .withNetworkDefault(new StrategyNetworkDefaultMap()
                            .withLimitPercent(100));
    private static final TextCampaignNetworkStrategyMap expectedContextStrategyMapWithoutParams =
            new TextCampaignNetworkStrategyMap()
                    .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT);
    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(value = 0)
    public String searchStrategyDescription;

    @Parameterized.Parameter(value = 1)
    public TextCampaignSearchStrategyAddMap searchStrategy;

    @Parameterized.Parameter(value = 2)
    public TextCampaignNetworkStrategyMap expectedNetworkStrategy;

    @Parameterized.Parameter(value = 3)
    public Boolean hasSetting;

    @Parameterized.Parameters(name = "search = {0}")
    public static Collection strategies() {
        Object[][] data = new Object[][]{
                {"AverageCpc",
                        new TextCampaignSearchStrategyAddMap().defaultAverageCpc(currency),
                        expectedContextStrategyMapWithoutParams,
                        true
                },
                {"WbMaximumClicks",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumClicks(currency),
                        expectedContextStrategyMapWithoutParams,
                        true
                },
                {"WbMaximumConversionRate",
                        new TextCampaignSearchStrategyAddMap().defaultWbMaximumConversionRate(currency, goalId),
                        expectedContextStrategyMapWithoutParams,
                        true
                },
                {"AverageCpa",
                        new TextCampaignSearchStrategyAddMap().defaultAverageCpa(currency, goalId),
                        expectedContextStrategyMapWithoutParams,
                        true
                },
        };
        return Arrays.asList(data);
    }

    @Before
    @Step("Подготовим данные для теста")
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(searchStrategy)
                                .withNetwork(new TextCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                                        .withNetworkDefault(new StrategyNetworkDefaultAddMap()
                                                .withLimitPercent(StrategyNetworkDefaultAddMap.DEFAULT_LIMIT_PERCENT))
                                )
                        )

                ));
    }

    @Test
    public void getNetworkDefaultTest() {
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(
                new GetRequestMap().withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(campaignId))
                        .withFieldNames(CampaignFieldEnum.ID)
                        .withTextCampaignFieldNames(TextCampaignFieldEnum.BIDDING_STRATEGY,
                                TextCampaignFieldEnum.SETTINGS));
        assumeThat("получили кампанию", campaigns, hasSize(1));
        TextCampaignStrategy actualStrategy = campaigns.get(0).getTextCampaign().getBiddingStrategy();
        assumeThat("получили стратегии кампании", actualStrategy, notNullValue());

        assertThat("получили корректную стратегию в сети", actualStrategy.getNetwork(),
                beanDifferV5((TextCampaignNetworkStrategy) expectedNetworkStrategy.getBean()));

        List<TextCampaignSettingGet> settings = campaigns.get(0).getTextCampaign().getSettings().stream()
                .filter(x -> (x.getOption().equals(TextCampaignSettingsGetEnum.MAINTAIN_NETWORK_CPC)))
                .collect(Collectors.toList());
        assertThat("получили настройку MAINTAIN_NETWORK_CPC", !settings.isEmpty(),
                equalTo(hasSetting));
    }
}
