package ru.yandex.autotests.direct.api.campaigns.production;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.GetResponse;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.ApiFeatures;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Smoke-тесты на проверку некоторых методов на production окружении
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-66636")
@Features(ApiFeatures.PRODUCTION)
@Description("Production smoke test: Campaigns. Создание/получение кампании.")
public class GetCampaignsProdTest {

    private static String client = CampaignsLogins.GET_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;

    @Before
    public void createCampaign() {
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();

        assumeThat("Кампания успешно создана", id, notNullValue());
    }

    @Test
    public void getCampaignTest() {
        GetResponse response = api.userSteps.campaignSteps().campaignsGet(new GetRequestMap()
                .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                        .withIds(id))
                .withFieldNames(CampaignFieldEnum.ID, CampaignFieldEnum.STATUS));

        assertThat("Получена кампания", response.getCampaigns(), hasSize(1));
    }

}
