package ru.yandex.autotests.direct.api.campaigns.resume;

import java.util.Arrays;
import java.util.Collection;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.RESUME)
@Description("Запрос на возобновление кампании с указанием невалидных идентификаторов")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ResumeCampaignsInvalidIdsTest {

    private static final String client = CampaignsLogins.SINGLE_CLIENT_RESUME;
    private static final String anotherClient = CampaignsLogins.SINGLE_CLIENT_ANOTHER;

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignDeleted;
    private static Long campaignAnother;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String operator;

    @Parameterized.Parameter(2)
    public Long campaignID;

    @Parameterized.Parameter(3)
    public ExpectedResult expectedResult;

    @Parameterized.Parameters(name = "test = {0}")
    public static Collection<Object[]> data() {
        prepareCampaigns();
        return Arrays.asList(new Object[][]{
                {"Нулевой ID кампании", client, 0L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(IdsCriteriaMap.IDS)))},
                {"Отрицательный ID кампании", client, -1L,
                        ExpectedResult.errorsIgnoringDetails(new Notification(5005,
                                Api5ErrorDetails.FIELD_MUST_BE_POSITIVE_INTEGER,
                                StringUtils.capitalize(IdsCriteriaMap.IDS)))},
                {"Несуществующая кампания", client, 123456L,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))},
                {"Удаленная кампания", client, campaignDeleted,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))},
                {"Чужая кампания", client, campaignAnother,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND))},
        });
    }

    private static void prepareCampaigns() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(anotherClient);

        api.as(anotherClient);
        campaignAnother = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsSuspend(campaignAnother);

        api.as(client);
        campaignDeleted = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsDelete(campaignDeleted);
    }

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("569")
    public void invalidIdsTest() {
        api.as(operator).userSteps.campaignSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                expectedResult);
    }
}
