package ru.yandex.autotests.direct.api.campaigns.resume;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 14.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.RESUME)
@Description("Проверка позитивных сценариев возобновления кампаний")
@Tag(TagDictionary.TRUNK)
public class ResumeCampaignsPositiveTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignID;
    private static Long campaignID1;
    private static Long campaignID2;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsSuspend(campaignID, campaignID1, campaignID2);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("576")
    public void resumeSingleCampaignTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.success(campaignID));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(campaignID, CampaignFieldEnum.STATE);
        assertThat("корректное значение поля State после возобновления кампании", campaign.getState(),
                equalTo(CampaignStateGetEnum.OFF));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("577")
    public void resumeTwoCampaignsTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID2)),
                ExpectedResult.success(campaignID1),
                ExpectedResult.success(campaignID2));
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignID1, campaignID2);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после остановки кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.OFF)));
    }
}
