package ru.yandex.autotests.direct.api.campaigns.resume;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.Logins;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.directapi.utils.AccessRightsErrorHelper.checkCatchingJavaAccessError;

/**
 * Created by chicos on 20.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.RESUME)
@Description("Возобновление кампаний от имени внутренних ролей")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class ResumeCampaignsRolesAccessTest {
    private LogSteps log = LogSteps.getLogger(this.getClass());

    @ClassRule
    public static ApiSteps api = new ApiSteps();

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter(0)
    public String campaignCreator;

    @Parameterized.Parameter(1)
    public String campaignResumer;

    @Parameterized.Parameter(2)
    public String clientForCreate;

    @Parameterized.Parameter(3)
    public String clientForResume;

    @Parameterized.Parameter(4)
    public ExpectedResult expectedResult;

    @Parameterized.Parameter(5)
    public Api5Error error;

    @Parameterized.Parameters(name = "creator = {0}, resumer = {1}, clientForCreate = {2}, clientForResume = {3}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Logins.MANAGER_DEFAULT, Logins.MANAGER_DEFAULT, CampaignsLogins.SERV_CLIENT,
                        CampaignsLogins.SERV_CLIENT,
                        ExpectedResult.success(),
                        null},
                {Logins.SUPER_LOGIN, Logins.PLACER, CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        ExpectedResult.errors(new Notification(54, Api5ErrorDetails.NO_RIGHTS_TO_WRITE)),
                        new Api5Error(54)},
                {Logins.SUPER_LOGIN, Logins.SUPPORT, CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        ExpectedResult.success(),
                        null},
                {Logins.SUPER_LOGIN, Logins.SUPER_LOGIN, CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        ExpectedResult.success(),
                        null},
                {Logins.SUPER_LOGIN, CampaignsLogins.SINGLE_CLIENT_ARCHIVE, CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        CampaignsLogins.SINGLE_CLIENT_ARCHIVE,
                        ExpectedResult.success(),
                        null},
                {Logins.SUPER_LOGIN, CampaignsLogins.SINGLE_CLIENT_REP, CampaignsLogins.SINGLE_CLIENT,
                        CampaignsLogins.SINGLE_CLIENT,
                        ExpectedResult.success(),
                        null},
                {CampaignsLogins.AGENCY_1_CAMPAIGNS, CampaignsLogins.AGENCY_1_CAMPAIGNS,
                        CampaignsLogins.SUBCLIENT_CAMPAIGNS, CampaignsLogins.SUBCLIENT_CAMPAIGNS,
                        ExpectedResult.success(),
                        null},
                {CampaignsLogins.AGENCY_REP_CAMPAIGNS, CampaignsLogins.AGENCY_REP_CAMPAIGNS,
                        CampaignsLogins.SUBCLIENT_CAMPAIGNS, CampaignsLogins.SUBCLIENT_CAMPAIGNS,
                        ExpectedResult.success(),
                        null},

                {CampaignsLogins.AGENCY_3, CampaignsLogins.AGENCY_3, CampaignsLogins.SUBCLIENT_1,
                        CampaignsLogins.SUBCLIENT_2,
                        ExpectedResult.errors(new Notification(8800, Api5ErrorDetails.CAMPAIGN_NOT_FOUND)),
                        null}
        });
    }

    private Long campaignID;

    @Before
    @Step("Подготовка данных для теста")
    public void prepareCampaign() {
        log.info("Сбросим использованные юниты");
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignResumer);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(campaignCreator);

        log.info("Создадим кампанию от имени " + campaignCreator);
        api.as(campaignCreator);
        campaignID = api.as(campaignCreator).userSteps.campaignSteps().addDefaultTextCampaign(clientForCreate);
        api.userSteps.campaignSteps().campaignsSuspend(clientForCreate, campaignID);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("578")
    public void resumeCampaignRolesTest() {
        checkCatchingJavaAccessError(
                error,
                () -> api.as(campaignResumer).userSteps.campaignSteps().shouldGetResultOn(
                        clientForResume,
                        Action.RESUME,
                        new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                                .withIds(campaignID)),
                        expectedResult
                )
        );
    }
}
