package ru.yandex.autotests.direct.api.campaigns.resume;

import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.ResumeRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 20.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.RESUME)
@Description("Проверка некорректной структуры запроса Resume")
@Tag(TagDictionary.TRUNK)
public class ResumeCampaignsStructureNegativeTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_RESUME;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("587")
    public void noSelectionCriteriaInRequestTest() {
        api.userSteps.campaignSteps().shouldGetCampaignErrorOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(null),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        "params",
                        StringUtils.capitalize(ResumeRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("588")
    public void emptySelectionCriteriaIdsTest() {
        api.userSteps.campaignSteps().shouldGetCampaignErrorOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()),
                new Api5Error(8000, Api5ErrorDetails.MISSING_REQUIRED_FIELD,
                        StringUtils.capitalize(ResumeRequestMap.SELECTION_CRITERIA),
                        StringUtils.capitalize(IdsCriteriaMap.IDS)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("586")
    public void emptyArrayOfIdsTest() {
        api.userSteps.campaignSteps().shouldGetCampaignErrorOn(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap().withIds()),
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                        StringUtils.capitalize(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Попытка возобновления кампаний, число которых в одном запросе превышает максимально допустимое - " +
            IdsCriteriaMap.CAMPAIGN_IDS_MAX_LENGTH)
    @ru.yandex.qatools.allure.annotations.TestCaseId("589")
    public void resumeCampaignOverlimitIdsTest() {
        Long[] fakeIds = new Long[IdsCriteriaMap.CAMPAIGN_IDS_MAX_LENGTH + 1];
        Arrays.fill(fakeIds, 0, IdsCriteriaMap.CAMPAIGN_IDS_MAX_LENGTH + 1, 123456L);

        api.userSteps.campaignSteps().shouldGetCampaignErrorOnIgnoringDetails(
                Action.RESUME,
                new ResumeRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(fakeIds)),
                new Api5Error(4001, Api5ErrorDetails.ARRAY_CANNOT_CONTAIN_MORE_THAN,
                        StringUtils.capitalize(IdsCriteriaMap.IDS),
                        IdsCriteriaMap.CAMPAIGN_IDS_MAX_LENGTH));
    }
}
