package ru.yandex.autotests.direct.api.campaigns.suspend;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 19.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.SUSPEND)
@Description("Проверка негативных сценариев остановки кампаний")
@Tag(TagDictionary.TRUNK)
public class SuspendCampaignsNegativeTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_SUSPEND;

    private static Long campaignID;
    private static Long campaignSuspended;

    private static Long campaignID1;
    private static Long campaignID2;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @Rule
    public Trashman trashman = new Trashman(api);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @BeforeClass
    public static void prepareCampaigns() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);

        campaignSuspended = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().campaignsSuspend(campaignSuspended);

        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Description("Попробуем остановить остановленную кампанию")
    @ru.yandex.qatools.allure.annotations.TestCaseId("622")
    public void suspendedCampaignTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignSuspended)),
                ExpectedResult.warnings(new Notification(10020,
                        Api5ErrorDetails.CAMPAIGN_ALREADY_SUSPENDED)));
    }

    @Test
    @Description("Остановка двух кампаний, идентификатор одной из которых - некорректен")
    @ru.yandex.qatools.allure.annotations.TestCaseId("620")
    public void suspendMultipleCampaignsOneInvalidTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID, 123456L)),
                ExpectedResult.success(campaignID),
                ExpectedResult.errors(new Notification(8800,
                        Api5ErrorDetails.CAMPAIGN_NOT_FOUND)));
    }

    @Test
    @Description("Два однинаковых идентификатора кампании в запросе")
    @ru.yandex.qatools.allure.annotations.TestCaseId("621")
    public void sameIdsInRequestTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID1, campaignID2)),
                ExpectedResult.warnings(
                        new Notification(10000,
                                Api5ErrorDetails.CAMPAIGN_ID_IS_PRESENTED_MORE_THAN_ONCE_IN_REQUEST)),
                ExpectedResult.warnings(
                        new Notification(10000,
                                Api5ErrorDetails.CAMPAIGN_ID_IS_PRESENTED_MORE_THAN_ONCE_IN_REQUEST)),
                ExpectedResult.success(campaignID2));

        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(campaignID1, CampaignFieldEnum.STATE);
        assertThat("кампания остановлена несмотря на warning", campaign.getState(),
                equalTo(CampaignStateGetEnum.SUSPENDED));
    }
}
