package ru.yandex.autotests.direct.api.campaigns.suspend;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.SuspendRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 18.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.SUSPEND)
@Description("Проверка позитивных сценариев остановки кампаний")
@Tag(TagDictionary.TRUNK)
public class SuspendCampaignsPositiveTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignID;
    private static Long campaignID1;
    private static Long campaignID2;

    @BeforeClass
    public static void prepareCampaigns() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID1 = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID2 = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("623")
    public void suspendSingleCampaignTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.success(campaignID));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(campaignID, CampaignFieldEnum.STATE);
        assertThat("корректное значение поля State после остановки кампании", campaign.getState(),
                equalTo(CampaignStateGetEnum.SUSPENDED));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("624")
    public void suspendTwoCampaignsTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.SUSPEND,
                new SuspendRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID2)),
                ExpectedResult.success(campaignID1),
                ExpectedResult.success(campaignID2));
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignID1, campaignID2);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после остановки кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.SUSPENDED)));
    }
}
