package ru.yandex.autotests.direct.api.campaigns.suspend;


import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusactive;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusshow;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.StatusClarification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.allure.LogSteps;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

@Aqua.Test
@Features(CampaignsFeatures.SUSPEND)
@Issue("https://st.yandex-team.ru/DIRECT-65045")
@Description("Проверка поля StatusClarification после остановки кампании")
@Tag(TagDictionary.TRUNK)
public class SuspendCampaignsStatusClarificationTest {

    private static LogSteps log = LogSteps.getLogger(SuspendCampaignsDBStatusTest.class);

    private static final String client = CampaignsLogins.SINGLE_CLIENT_SUSPEND;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long campaignId;

    @BeforeClass
    public static void prepareCampaign() {

        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignId = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignId);
        Long adID = api.userSteps.adsSteps().addDefaultTextAd(groupID);

        api.userSteps.campaignFakeSteps().setCampaignSum(
                campaignId, MoneyCurrency.get(Currency.RUB).getMinInvoiceAmount().floatValue());

        log.info("Промодерируем фейково");
        api.userSteps.campaignFakeSteps().makeCampaignModerated(campaignId);
        api.userSteps.groupFakeSteps().makeGroupFullyModerated(groupID);
        api.userSteps.bannersFakeSteps().makeBannersModerated(adID);

        api.userSteps.campaignFakeSteps().setStatusActive(campaignId, Status.YES);

        CampaignsRecord campaign = api.userSteps.getDirectJooqDbSteps()
                .useShardForLogin(client).campaignsSteps()
                .getCampaignById(campaignId);
        assumeThat("Кампания активна", campaign.getStatusactive(), equalTo(CampaignsStatusactive.Yes));
        assumeThat("Идут показы", campaign.getStatusshow(), equalTo(CampaignsStatusshow.Yes));

        log.info("Остановим кампанию");
        List<Long> ids = api.userSteps.campaignSteps().campaignsSuspend(campaignId);
        assumeThat("получили идентификатор остановленной кампании", ids, hasSize(1));
    }

    @Test
    public void suspendSingleCampaignTest() {
        CampaignGetItem campaign = api.userSteps.campaignSteps()
                .campaignsGet(campaignId, CampaignFieldEnum.STATUS_CLARIFICATION, CampaignFieldEnum.STATE);

        assertThat("корректное значение поля StatusClarification после остановки кампании",
                campaign.getStatusClarification(), equalTo(StatusClarification.SUSPENDED.getStatusClarification()));
    }

}
