package ru.yandex.autotests.direct.api.campaigns.unarchive;

import java.util.Arrays;

import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.ApiStories;
import ru.yandex.autotests.directapi.apiclient.config.ProtocolType;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.version5.ServiceNames;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.UnarchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Stories;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by chicos on 18.08.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UNARCHIVE)
@Stories(ApiStories.JSON5)
@Description("Валидация JSON-запроса при разархивации кампаний")
@Tag(TagDictionary.TRUNK)
public class UnarchiveCampaignsStructureNegativeJsonTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_UNARCHIVE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client).protocol(ProtocolType.JSON);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Before
    public void clearUnits() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Test
    @Description("Массив в поле SelectionCriteria")
    @ru.yandex.qatools.allure.annotations.TestCaseId("684")
    public void arrayInSelectionCriteriaFieldTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(UnarchiveRequestMap.SELECTION_CRITERIA), new Object[]{
                        new IdsCriteriaMap().withIds(0L).getBean()});

        api.userSteps.campaignSteps().shouldGetJSONErrorOn(
                ServiceNames.CAMPAIGNS,
                client,
                Action.UNARCHIVE,
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        StringUtils.capitalize(UnarchiveRequestMap.SELECTION_CRITERIA)));
    }

    @Test
    @Description("Целое число вместо массива SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("685")
    public void notAnArrayInIdsFieldTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(UnarchiveRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(IdsCriteriaMap.IDS), 0L));

        api.userSteps.campaignSteps().shouldGetJSONErrorOn(
                ServiceNames.CAMPAIGNS,
                client,
                Action.UNARCHIVE,
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_ARRAY,
                        StringUtils.capitalize(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Строка в качестве элемента массива SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("686")
    public void stringInIdsArrayTest() {
        String value = "INVALID_VALUE";

        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(UnarchiveRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(IdsCriteriaMap.IDS), Arrays.asList(value)));

        api.userSteps.campaignSteps().shouldGetJSONErrorOn(
                ServiceNames.CAMPAIGNS,
                client,
                Action.UNARCHIVE,
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        StringUtils.capitalize(IdsCriteriaMap.IDS)));
    }

    @Test
    @Description("Массив внутри массива SelectionCriteria.Ids")
    @ru.yandex.qatools.allure.annotations.TestCaseId("687")
    public void arrayInIdsArrayTest() {
        JsonObject request = new JsonObject()
                .with(StringUtils.capitalize(UnarchiveRequestMap.SELECTION_CRITERIA), new JsonObject()
                        .with(StringUtils.capitalize(IdsCriteriaMap.IDS), new Long[][]{new Long[]{0L}}));

        api.userSteps.campaignSteps().shouldGetJSONErrorOn(
                ServiceNames.CAMPAIGNS,
                client,
                Action.UNARCHIVE,
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_MUST_CONTAIN_INTEGER_VALUE,
                        StringUtils.capitalize(IdsCriteriaMap.IDS)));
    }
}
