package ru.yandex.autotests.direct.api.campaigns.unarchive;

import java.util.List;

import com.yandex.direct.api.v5.campaignsext.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaignsext.CampaignGetItem;
import com.yandex.direct.api.v5.campaignsext.CampaignStateGetEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.UnarchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@Features(CampaignsFeatures.UNARCHIVE)
@Description("Проверка позитивных сценариев разархивации ContentPromotion кампаний")
public class UnarchiveContentPromotionCampaignsPositiveTest {

    private static final String client = CampaignsLogins.SINGLE_CLIENT_UNARCHIVE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignIdContentPromotion;
    private static Long campaignIdText;
    private static Long campaignID;
    private static Long campaignID1;
    private static Long campaignID2;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignIdContentPromotion = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignIdText = api.userSteps.campExtSteps().addDefaultTextCampaign();
        campaignID = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignID1 = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        campaignID2 = api.userSteps.campExtSteps().addDefaultContentPromotionCampaign();
        api.userSteps.campExtSteps()
                .campaignsSuspend(campaignID, campaignID1, campaignID2, campaignIdText, campaignIdContentPromotion);
        api.userSteps.campExtSteps()
                .campaignsArchive(campaignID, campaignID1, campaignID2, campaignIdText, campaignIdContentPromotion);
    }

    @Test
    public void unarchiveSingleContentPromotionCampaignTest() {
        api.userSteps.campExtSteps().shouldGetResultOn(
                Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.success(campaignID));
        CampaignGetItem campaign = api.userSteps.campExtSteps().campaignsGet(campaignID, CampaignFieldEnum.STATE);
        assertThat("корректное значение поля State после разархивирования ContentPromotion кампании", campaign.getState(),
                equalTo(CampaignStateGetEnum.SUSPENDED));
    }

    @Test
    public void unarchiveTwoContentPromotionCampaignsTest() {
        api.userSteps.campExtSteps().shouldGetResultOn(
                Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID2)),
                ExpectedResult.success(campaignID1),
                ExpectedResult.success(campaignID2));
        List<CampaignGetItem> campaigns = api.userSteps.campExtSteps().getCampaigns(campaignID1, campaignID2);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после разархивирования ContentPromotion кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.SUSPENDED)));
    }

    @Test
    public void unarchiveCampaignsDifferentTypesTest() {
        api.userSteps.campExtSteps().shouldGetResultOn(
                Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignIdText, campaignIdContentPromotion)),
                ExpectedResult.success(campaignIdText),
                ExpectedResult.success(campaignIdContentPromotion));
        List<CampaignGetItem> campaigns =
                api.userSteps.campExtSteps().getCampaigns(campaignIdText, campaignIdContentPromotion);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после разархивирования кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.SUSPENDED)));
    }
}
