package ru.yandex.autotests.direct.api.campaigns.unarchive;

import java.util.List;

import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import com.yandex.direct.api.v5.campaigns.CampaignStateGetEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.model.api5.Action;
import ru.yandex.autotests.directapi.model.api5.campaigns.UnarchiveRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.IdsCriteriaMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ch.lambdaj.Lambda.extract;
import static ch.lambdaj.Lambda.on;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.everyItem;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by chicos on 25.09.15.
 */
@Aqua.Test
@Features(CampaignsFeatures.UNARCHIVE)
@Description("Проверка позитивных сценариев разархивации мобильной кампаний")
@Tag(TagDictionary.TRUNK)
public class UnarchiveMobileCampaignsPositiveTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_UNARCHIVE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    private static Long campaignIdMobile;
    private static Long campaignIdText;
    private static Long campaignID;
    private static Long campaignID1;
    private static Long campaignID2;

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        campaignIdMobile = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        campaignIdText = api.userSteps.campaignSteps().addDefaultTextCampaign();
        campaignID = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        campaignID1 = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        campaignID2 = api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignSteps()
                .campaignsSuspend(campaignID, campaignID1, campaignID2, campaignIdText, campaignIdMobile);
        api.userSteps.campaignSteps()
                .campaignsArchive(campaignID, campaignID1, campaignID2, campaignIdText, campaignIdMobile);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("718")
    public void unarchiveSingleMobileCampaignTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID)),
                ExpectedResult.success(campaignID));
        CampaignGetItem campaign = api.userSteps.campaignSteps().campaignsGet(campaignID, CampaignFieldEnum.STATE);
        assertThat("корректное значение поля State после разархивирования мобильной кампании", campaign.getState(),
                equalTo(CampaignStateGetEnum.SUSPENDED));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("719")
    public void unarchiveTwoMobileCampaignsTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignID1, campaignID2)),
                ExpectedResult.success(campaignID1),
                ExpectedResult.success(campaignID2));
        List<CampaignGetItem> campaigns = api.userSteps.campaignSteps().getCampaigns(campaignID1, campaignID2);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после разархивирования мобильной кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.SUSPENDED)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("720")
    public void unarchiveCampaignsDifferentTypesTest() {
        api.userSteps.campaignSteps().shouldGetResultOn(
                Action.UNARCHIVE,
                new UnarchiveRequestMap().withSelectionCriteria(new IdsCriteriaMap()
                        .withIds(campaignIdText, campaignIdMobile)),
                ExpectedResult.success(campaignIdText),
                ExpectedResult.success(campaignIdMobile));
        List<CampaignGetItem> campaigns =
                api.userSteps.campaignSteps().getCampaigns(campaignIdText, campaignIdMobile);
        List<CampaignStateGetEnum> states = extract(campaigns, on(CampaignGetItem.class).getState());
        assertThat("корректное значение поля State после разархивирования мобильной кампании", states,
                everyItem(equalTo(CampaignStateGetEnum.SUSPENDED)));
    }
}
