package ru.yandex.autotests.direct.api.campaigns.unarchive.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.CampaignsStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.CampaignsRecord;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

@Aqua.Test
@RunWith(Parameterized.class)
@Features(CampaignsFeatures.UNARCHIVE)
@Description("Проверка статуса модерации кампании после разархивации")
@Tag(TagDictionary.TRUNK)
public class UnarchiveCampaignStatusModerateCampaignTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_UNARCHIVE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @Parameterized.Parameter()
    public Boolean hasBids;

    @Parameterized.Parameter(1)
    public CampaignsStatusmoderate statusModerateBefore;

    @Parameterized.Parameter(2)
    public CampaignsStatusmoderate statusModerateAfter;

    @Parameterized.Parameters(name = "Есть bids {0}; До разархивации {1}, после {2}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {false, CampaignsStatusmoderate.Yes, CampaignsStatusmoderate.Yes},
                {true, CampaignsStatusmoderate.Yes, CampaignsStatusmoderate.Yes},
                {false, CampaignsStatusmoderate.No, CampaignsStatusmoderate.No},
                {true, CampaignsStatusmoderate.No, CampaignsStatusmoderate.Ready},
                {false, CampaignsStatusmoderate.Sent, CampaignsStatusmoderate.Sent},
                {true, CampaignsStatusmoderate.Sent, CampaignsStatusmoderate.Sent},
                {true, CampaignsStatusmoderate.Ready, CampaignsStatusmoderate.Ready},
                {false, CampaignsStatusmoderate.New, CampaignsStatusmoderate.New},
                {true, CampaignsStatusmoderate.New, CampaignsStatusmoderate.Ready},
                {true, CampaignsStatusmoderate.Mediaplan, CampaignsStatusmoderate.Mediaplan},
        });
    }

    @Test
    public void statusModerateTest() {
        Long campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        if (hasBids) {
            Long groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
            Long adID = api.userSteps.adsSteps().addDefaultTextAd(groupID);
            api.userSteps.keywordsSteps().addDefaultKeyword(groupID);
            api.userSteps.bannersFakeSteps().makeBannerActive(adID);
        }
        api.userSteps.campaignSteps().campaignsSuspend(campaignID);
        api.userSteps.campaignSteps().campaignsArchive(campaignID);

        api.userSteps.campaignFakeSteps().setStatusModerate(campaignID, statusModerateBefore.name());

        api.userSteps.campaignSteps().campaignsUnarchive(campaignID);

        CampaignsRecord campaignDB = api.userSteps.getDirectJooqDbSteps().useShardForLogin(client)
                .campaignsSteps().getCampaignById(campaignID);
        assertThat("статус модерации кампании соответствует ожидаемому",
                campaignDB.getStatusmoderate(), equalTo(statusModerateAfter));
    }
}
