package ru.yandex.autotests.direct.api.campaigns.unarchive.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.enums.ImageType;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Step;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.arrayWithSize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by chicos on 27.08.15.
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(CampaignsFeatures.UNARCHIVE)
@Description("Проверка статуса модерации картинок при разархивации кампании")
@Tag(TagDictionary.TRUNK)
public class UnarchiveCampaignStatusModerateImageTest {
    private static final String client = CampaignsLogins.SINGLE_CLIENT_UNARCHIVE;

    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignID;
    private Long adID;
    private Long groupID;

    @Parameterized.Parameter(0)
    public String statusModerateBefore;

    @Parameterized.Parameter(1)
    public String statusModerateAfter;

    @Parameterized.Parameters(name = "До разархивации {0}, после {1}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {Status.YES, Status.YES},
                {Status.NO, Status.NO},
                {Status.SENT, Status.READY},
                {Status.SENDING, Status.READY},
                {Status.READY, Status.READY},
                {Status.NEW, Status.NEW}
        });
    }

    @Before
    @Step("Подготовка данных для теста")
    public void prepareData() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        groupID = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID);
        adID = api.userSteps.adsSteps().addDefaultTextAd(groupID);
        api.userSteps.keywordsSteps().addDefaultKeyword(groupID);

        String[] hashes = api.userSteps.imagesSteps().configLoginImages(client, ImageType.REGULAR, 1);
        assumeThat("получили хэш картинки", hashes, arrayWithSize(1));
        api.userSteps.imagesSteps().setAdImageAssociation(adID, hashes[0]);

        api.userSteps.campaignSteps().campaignsSuspend(campaignID);
        api.userSteps.campaignSteps().campaignsArchive(campaignID);

        api.userSteps.bannersFakeSteps().setStatusModerate(adID, Status.YES);
        api.userSteps.bannersFakeSteps().setImageStatusModerate(adID, statusModerateBefore);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("723")
    public void imageStatusModerateTest() {
        api.userSteps.campaignSteps().campaignsUnarchive(campaignID);

        BannerFakeInfo groupInfo = api.userSteps.bannersFakeSteps().getBannerParams(adID);
        assertThat("статус модерации картинки соответствует ожидаемому",
                groupInfo.getImageStatusModerate(), equalTo(statusModerateAfter));
    }
}
