package ru.yandex.autotests.direct.api.campaigns.unarchive.moderate;

import java.util.Arrays;
import java.util.Collection;

import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersPhoneflag;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatusmoderate;
import ru.yandex.autotests.direct.db.models.jooq.ppc.enums.BannersStatussitelinksmoderate;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.BannerFakeInfo;
import ru.yandex.autotests.directapi.model.api5.ads.AdAddItemMap;
import ru.yandex.autotests.directapi.model.api5.ads.TextAdAddMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.beandiffer.BeanDifferMatcher.beanEquivalent;

/**
 * Created by chicos on 27.08.15.
 */
@Aqua.Test
@RunWith(Parameterized.class)
@Features(CampaignsFeatures.UNARCHIVE)
@Description("Проверка статуса модерации группы объявлений при разархивации кампании")
@Tag(TagDictionary.TRUNK)
public class UnarchiveCampaignStatusModeratePhoneSitelinkTest {
    private static final String client = CampaignsLogins.CLIENT_SELF;//SINGLE_CLIENT_UNARCHIVE;


    @ClassRule
    public static ApiSteps api = new ApiSteps().as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long campaignID;
    private Long adID;

    @Parameterized.Parameter(0)
    public BannersStatusmoderate bannerStatusModerate;

    @Parameterized.Parameter(1)
    public BannersPhoneflag phoneFlagBefore;

    @Parameterized.Parameter(2)
    public BannersPhoneflag phoneFlagAfter;

    @Parameterized.Parameter(3)
    public BannersStatussitelinksmoderate statusSitelinksModerateBefore;

    @Parameterized.Parameter(4)
    public BannersStatussitelinksmoderate statusSitelinksModerateAfter;

    @Parameterized.Parameters(name = "Статус объявления {0}; статус phoneFlag до {1}, после {2}; " +
            "статус sitelinks до {3}, после {4}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {BannersStatusmoderate.Sent, BannersPhoneflag.Sent, BannersPhoneflag.Ready,
                        BannersStatussitelinksmoderate.Sent, BannersStatussitelinksmoderate.Ready},
                {BannersStatusmoderate.Sent, BannersPhoneflag.Yes, BannersPhoneflag.Ready,
                        BannersStatussitelinksmoderate.Yes, BannersStatussitelinksmoderate.Ready},
                {BannersStatusmoderate.Sending, BannersPhoneflag.Yes, BannersPhoneflag.Ready,
                        BannersStatussitelinksmoderate.Yes, BannersStatussitelinksmoderate.Ready},
                {BannersStatusmoderate.Sending, BannersPhoneflag.No, BannersPhoneflag.Ready,
                        BannersStatussitelinksmoderate.New, BannersStatussitelinksmoderate.Ready},
                {BannersStatusmoderate.Ready, BannersPhoneflag.Yes, BannersPhoneflag.Ready,
                        BannersStatussitelinksmoderate.Yes, BannersStatussitelinksmoderate.Ready},
                {BannersStatusmoderate.No, BannersPhoneflag.Yes, BannersPhoneflag.Yes,
                        BannersStatussitelinksmoderate.Yes, BannersStatussitelinksmoderate.Yes},
                {BannersStatusmoderate.Yes, BannersPhoneflag.Yes, BannersPhoneflag.Yes,
                        BannersStatussitelinksmoderate.Sent, BannersStatussitelinksmoderate.Ready},
                {BannersStatusmoderate.Yes, BannersPhoneflag.Sending, BannersPhoneflag.Ready,
                        BannersStatussitelinksmoderate.Yes, BannersStatussitelinksmoderate.Yes},
                {BannersStatusmoderate.Yes, BannersPhoneflag.Ready, BannersPhoneflag.Ready,
                        BannersStatussitelinksmoderate.Ready, BannersStatussitelinksmoderate.Ready},
                {BannersStatusmoderate.Yes, BannersPhoneflag.Yes, BannersPhoneflag.Yes,
                        BannersStatussitelinksmoderate.Yes, BannersStatussitelinksmoderate.Yes},
                {BannersStatusmoderate.New, BannersPhoneflag.No, BannersPhoneflag.No,
                        BannersStatussitelinksmoderate.New, BannersStatussitelinksmoderate.New},
                {BannersStatusmoderate.No, BannersPhoneflag.New, BannersPhoneflag.New,
                        BannersStatussitelinksmoderate.No, BannersStatussitelinksmoderate.No},
        });
    }

    @Test
    public void phoneAndSitelinkStatusModerateTest() {
        campaignID = api.userSteps.campaignSteps().addDefaultTextCampaign();
        Long adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(campaignID, client);
        Long sitelinkSetId = api.userSteps.sitelinksSteps().addDefaultSet(1);
        Long vCardId = api.userSteps.vCardsSteps().addDefaultVCard(campaignID);
        adID = api.userSteps.adsSteps().addAd(new AdAddItemMap()
                        .withTextAd(new TextAdAddMap().defaultTextAd()
                                .withSitelinkSetId(sitelinkSetId)
                                .withVCardId(vCardId))
                        .withAdGroupId(adGroupId)
                , client);
        api.userSteps.keywordsSteps().addDefaultKeyword(adGroupId);
        api.userSteps.campaignSteps().campaignsSuspend(campaignID);
        api.userSteps.campaignSteps().campaignsArchive(campaignID);

        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).bannersSteps()
                .setBannerStatusModerate(adID, bannerStatusModerate);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).bannersSteps()
                .setStatusSitelinksModerate(adID, statusSitelinksModerateBefore);
        api.userSteps.getDirectJooqDbSteps().useShardForLogin(client).bannersSteps()
                .setPhoneflag(adID, phoneFlagBefore);

        api.userSteps.campaignSteps().campaignsUnarchive(campaignID);
        BannerFakeInfo actualBannerInfo = api.userSteps.bannersFakeSteps().getBannerParams(adID);

        BannerFakeInfo expectedBannerInfo = new BannerFakeInfo();
        expectedBannerInfo.setStatusSitelinksModerate(statusSitelinksModerateAfter.toString());
        expectedBannerInfo.setPhoneFlag(phoneFlagAfter.toString());

        assertThat("статусы модерации соответствуют ожидаемым", actualBannerInfo, beanEquivalent(expectedBannerInfo));
    }
}
