package ru.yandex.autotests.direct.api.campaigns.units;

import com.google.common.collect.Iterables;
import com.yandex.direct.api.v5.campaigns.ApiException;
import com.yandex.direct.api.v5.campaigns.CampaignFieldEnum;
import com.yandex.direct.api.v5.campaigns.CampaignTypeEnum;
import com.yandex.direct.api.v5.campaigns.CampaignsPort;
import com.yandex.direct.api.v5.campaigns.GetRequest;

import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignsSelectionCriteriaMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.GetRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.LimitOffsetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalPageErrorTestData;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProvider;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProviderImpl;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalWsdlErrorTestData;

import static ru.yandex.autotests.directapi.test.units.UnitsHeaderUtil.getUnitsUsedLoginHeader;
import static ru.yandex.autotests.directapi.test.units.UnitsWithdrawalErrorTestDataUtil.errorExpected;

class UnitsCampaignsErrorTestData {

    private final ApiSteps api;

    private final UnitsWithdrawalTestDataProvider dataProvider;

    UnitsCampaignsErrorTestData(ApiSteps api) {
        this.api = api;
        this.dataProvider = new UnitsWithdrawalTestDataProviderImpl();
    }

    Iterable<Object[]> provideData() {
        return Iterables.concat(
                pageLimitErrorDataSets(),
                wsdlValidationErrorDataSets()
        );
    }

    private Iterable<Object[]> pageLimitErrorDataSets() {
        return dataProvider.buildDataSets(
                UnitsWithdrawalPageErrorTestData.pageLimitExceeded(),

                getUnitsUsedLoginHeader((String clientLogin) -> {
                    CampaignsPort port = api.userSteps.soapClientV5().campaignsService(clientLogin);

                    errorExpected(
                            ApiException.class,
                            () -> port.get((GetRequest) new GetRequestMap()
                                    .withSelectionCriteria(new CampaignsSelectionCriteriaMap()
                                            .withTypes(CampaignTypeEnum.TEXT_CAMPAIGN))
                                    .withFieldNames(CampaignFieldEnum.ID)
                                    .withPage(new LimitOffsetMap().withLimit(Long.MAX_VALUE))
                                    .getBean()),
                            e -> e.getFaultInfo().getErrorCode(),

                            UnitsWithdrawalPageErrorTestData.PAGE_LIMIT_EXCEEDED_ERROR_CODE
                    ).run();

                    return port;
                })
        );
    }

    private Iterable<Object[]> wsdlValidationErrorDataSets() {
        return dataProvider.buildDataSets(

                UnitsWithdrawalWsdlErrorTestData.wsdlErrorExpected(),

                getUnitsUsedLoginHeader((String clientLogin) -> {
                    CampaignsPort port = api.userSteps.soapClientV5().campaignsService(clientLogin);

                    errorExpected(
                            ApiException.class,
                            // (!) здесь используется BadGetRequestMap, не GetRequestMap
                            () -> port.get((GetRequest) new BadGetRequestMap().getBean()),
                            e -> e.getFaultInfo().getErrorCode(),

                            UnitsWithdrawalWsdlErrorTestData.WSDL_ERROR_CODE
                    ).run();

                    return port;
                })

        );
    }

}


