package ru.yandex.autotests.direct.api.campaigns.units;

import java.util.List;
import java.util.function.Function;

import com.yandex.direct.api.v5.campaigns.AddRequest;
import com.yandex.direct.api.v5.campaigns.ApiException;
import com.yandex.direct.api.v5.campaigns.CampaignsPort;

import ru.yandex.autotests.directapi.apiclient.errors.Api5JsonError;
import ru.yandex.autotests.directapi.model.api5.campaigns.AddRequestMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProvider;
import ru.yandex.autotests.directapi.test.units.UnitsWithdrawalTestDataProviderImpl;

import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.notNullValue;
import static ru.yandex.autotests.directapi.test.units.UnitsHeaderUtil.getUnitsUsedLoginHeader;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

class UnitsCampaignsTestData {

    private final UnitsWithdrawalTestDataProvider dataProvider;

    private final ApiSteps api;

    UnitsCampaignsTestData(ApiSteps api) {
        this.api = api;
        this.dataProvider = new UnitsWithdrawalTestDataProviderImpl();
    }

    Iterable<Object[]> provideData() {
        return dataProvider.buildDataSets(
                this::runGetRequest,
                this::runAddRequest
        );
    }

    void runGetRequest() {
        try {
            List<Long> ids = api.userSteps.campaignSteps().getAllCampaignIds();
            assumeThat("Кампании получены", ids, not(empty()));
        } catch (Api5JsonError ignore) {
            // игнорируем ошибку, чтобы можно было достать заголовки из ошибочного запроса
        }
    }

    void runAddRequest() {
        try {
            Long id = api.userSteps.campaignSteps().addDefaultTextCampaign();
            assumeThat("Кампания создана", id, notNullValue());
        } catch (Api5JsonError ignore) {
            // игнорируем ошибку, чтобы можно было достать заголовки из ошибочного запроса
        }
    }

    Function<String, String> runAddRequestWithHeaderCheck() {
        return getUnitsUsedLoginHeader((String clientLogin) -> {
            CampaignsPort port = api.userSteps.soapClientV5().campaignsService(clientLogin);
            try {
                port.add((AddRequest) new AddRequestMap().withCampaigns(
                        new CampaignAddItemMap().defaultCampaignAddItem().withDefaultTextCampaign()).getBean());
            } catch (ApiException ignore) {
                // игнорируем ошибку, чтобы можно было достать заголовки из ошибочного запроса
            }

            return port;
        });
    }

}
