package ru.yandex.autotests.direct.api.campaigns.update;

import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetailsJava;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlApi5Error;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 18.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка правильности списания баллов")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
public class CampaignsUpdateUnitsTest {

    private static final String client = CampaignsLogins.CLIENT_UNITS_UPDATE;

    public static final int CALL_COST = 10;
    public static final int CAMPAIGN_COST = 3;
    public static final int DEFAULT_ERROR_COST = 20;
    public static final int COMMON_REQUEST_ERROR = 50;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private Long id;
    private Long idElse;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
    }

    @Before
    public void createCampaign() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        idElse = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("727")
    public void updateOneCampaign() {
        //DIRECT-46263
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap()
                        .withId(id)
                        .withName("someNewName")));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("728")
    public void updateTwoCampaigns() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().campaignsUpdate(new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap()
                        .withId(id)
                        .withName("someNewName"),
                new CampaignUpdateItemMap()
                        .withId(idElse)
                        .withName("someNewName")));
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + 2 * CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("729")
    public void updateOneCampaignWithError() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(id)
                                .withStartDate("invalidDate")),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("730")
    public void updateTwoCampaignsWithOneError() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(id)
                                .withName("someNewName"),
                        new CampaignUpdateItemMap()
                                .withId(idElse)
                                .withStartDate("invalidDate")),
                JavaOrPerlExpectedResult.both(ExpectedResult.success()),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + DEFAULT_ERROR_COST + CAMPAIGN_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("731")
    public void updateTwoCampaignsWithTwoErrors() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap().withCampaigns(
                        new CampaignUpdateItemMap()
                                .withId(id)
                                .withStartDate("invalidDate"),
                        new CampaignUpdateItemMap()
                                .withId(idElse)
                                .withStartDate("invalidDate")),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE))),
                JavaOrPerlExpectedResult
                        .java(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetailsJava.VALUE_INVALID_FORMAT_IN_FILED, "StartDate")))
                        .perl(ExpectedResult.errors(new Notification(5004,
                                Api5ErrorDetails.INVALID_CAMPAIGN_START_DATE)))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(CALL_COST + 2 * DEFAULT_ERROR_COST));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("732")
    public void updateWithInvalidRequest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        int unitsBefore = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(new UpdateRequestMap().withCampaigns(null),
                JavaOrPerlApi5Error
                        .java(new Api5Error(8000, Api5ErrorDetailsJava.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                                capitalize(UpdateRequestMap.CAMPAIGNS), 1))
                        .perl(new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_NOT_LESS_ELEMENTS,
                                capitalize(UpdateRequestMap.CAMPAIGNS)))
        );
        int unitsAfter = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assertThat("списалось правильное количество баллов",
                unitsBefore - unitsAfter, equalTo(COMMON_REQUEST_ERROR));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("733")
    public void callCampaignsUpdateWithZeroUnits() {
        int units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        api.userSteps.clientFakeSteps().fakeWithdrawClientUnits(client, units);
        units = api.userSteps.clientFakeSteps().fakeClientUnitsBalance(client);
        assumeThat("у клиента не осталось баллов", units, equalTo(0));
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(new UpdateRequestMap().withCampaigns(
                new CampaignUpdateItemMap()
                        .withId(id)
                        .withName("someNewName")),
                new Api5Error(152, Api5ErrorDetails.NOT_ENOUGH_UNITS_FOR_OPERATION)
        );
    }
}
