package ru.yandex.autotests.direct.api.campaigns.update;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import com.yandex.direct.api.v5.campaigns.RelevantKeywordsModeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.joda.time.DateTime;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.money.Currency;
import ru.yandex.autotests.direct.utils.money.MoneyCurrency;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.RelevantKeywordsSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyAddMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TimeTargetingOnPublicHolidaysMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.campaigns.TimeTargetMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.autotests.irt.testutils.RandomUtils;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by pavryabov on 18.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Поверка StatusBsSynced после обновления нескольких кампании")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Tag(TagDictionary.TRUNK)
public class CheckLastChangeAfterMassUpdateTest {
    private static final String SSP_PLATFORM_DEFAULT = "Rubicon";
    private static final String DOMAIN = "qwerty.ru";

    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;
    private static Long idElse;
    private String lastChange;

    @BeforeClass
    public static void initTest() {
        api.userSteps.getDirectJooqDbSteps().sspPlatformsSteps().saveSspPlatformsIfNotExist(SSP_PLATFORM_DEFAULT);
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .withName("name")
                .withStartDate(DateTime.now().toLocalDate().toString())
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                                .withNetwork(new TextCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(
                                                TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)))));
        idElse = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .withName("name")
                .withStartDate(DateTime.now().toLocalDate().toString())
                .withTextCampaign(new TextCampaignAddItemMap()
                        .withBiddingStrategy(new TextCampaignStrategyAddMap()
                                .withSearch(new TextCampaignSearchStrategyAddMap()
                                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                                .withNetwork(new TextCampaignNetworkStrategyAddMap()
                                        .withBiddingStrategyType(
                                                TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)))));
    }

    @Before
    public void setLastChange() {
        lastChange = DateTime.now().minusMinutes(10).toString("yyyy-MM-dd hh:mm:ss");
        api.userSteps.campaignFakeSteps().setLastChange(id, lastChange);
        api.userSteps.campaignFakeSteps().setLastChange(idElse, lastChange);
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у кампании сдвинут в прошлое", campaignFakeInfo.getLastChange(), equalTo(lastChange));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у кампании сдвинут в прошлое", campaignFakeInfo.getLastChange(), equalTo(lastChange));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("734")
    public void updateClientInfo() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withClientInfo("someNewClientInfo"),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withClientInfo("someNewClientInfo")),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("735")
    public void updateNotification() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withNotification(new NotificationMap()
                                                .withSmsSettings(new SmsSettingsMap()
                                                        .withTimeFrom("20:00")
                                                        .withTimeTo("20:15"))
                                                .withEmailSettings(new EmailSettingsMap().withEmail("somenewemail@mail.ru"))),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withNotification(new NotificationMap()
                                                .withSmsSettings(new SmsSettingsMap()
                                                        .withTimeFrom("20:00")
                                                        .withTimeTo("20:15"))
                                                .withEmailSettings(new EmailSettingsMap().withEmail("somenewemail@mail.ru")))),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("736")
    public void updateEndDate() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withEndDate(DateTime.now().plusDays(23).toLocalDate().toString()),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withEndDate(DateTime.now().plusDays(23).toLocalDate().toString())),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("737")
    public void updateStartDate() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withStartDate(DateTime.now().plusDays(1).toLocalDate().toString()),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withStartDate(DateTime.now().plusDays(1).toLocalDate().toString())),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("738")
    public void updateTimeTargeting() {
        //DIRECT-45952
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withTimeTargeting(new TimeTargetingMap()
                                                .withConsiderWorkingWeekends(YesNoEnum.YES)
                                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                                        .withSuspendOnHolidays(YesNoEnum.NO)
                                                        .withStartHour(15)
                                                        .withEndHour(16))),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withTimeTargeting(new TimeTargetingMap()
                                                .withConsiderWorkingWeekends(YesNoEnum.NO)
                                                .withHolidaysSchedule(new TimeTargetingOnPublicHolidaysMap()
                                                        .withSuspendOnHolidays(YesNoEnum.NO)
                                                        .withStartHour(15)
                                                        .withEndHour(16)))),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("739")
    public void updateTimeZone() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withTimeZone(TimeTargetMap.TimeZone.ASIA_VIENTIANE),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withTimeZone(TimeTargetMap.TimeZone.ASIA_VIENTIANE)),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("740")
    public void updateNegativeKeywords() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withNegativeKeywords("newNegativeKeyword"),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withNegativeKeywords("newNegativeKeyword")),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("741")
    public void updateBlockedIps() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withBlockedIps("12.32.32.21"),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withBlockedIps("12.32.32.21")),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("742")
    public void updateExcludedSitesDomain() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withExcludedSites(DOMAIN),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withExcludedSites(DOMAIN)),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("743")
    public void updateExcludedSitesSSPPlatform() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withExcludedSites(SSP_PLATFORM_DEFAULT),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withExcludedSites(SSP_PLATFORM_DEFAULT)),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("744")
    public void updateName() {

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withName("someNewName"),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withName("someNewName")),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("745")
    public void updateDailyBudget() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withDailyBudget(new DailyBudgetMap()
                                                .withAmount(
                                                        MoneyCurrency.get(Currency.RUB).getMinDayBudgetAmount().bidLong().longValue())
                                                .withMode(DailyBudgetModeEnum.DISTRIBUTED)),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withDailyBudget(new DailyBudgetMap()
                                                .withAmount(MoneyCurrency.get(Currency.RUB).getMinDayBudgetAmount().bidLong()
                                                        .longValue())
                                                .withMode(DailyBudgetModeEnum.DISTRIBUTED))),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("746")
    public void updateCounterIds() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                                .withCounterIds(RandomUtils.getRandomInteger(0, 10000000))),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                                .withCounterIds(RandomUtils.getRandomInteger(0, 10000000)))),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("747")
    public void updateRelevantKeywordsSetting() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                                .withRelevantKeywords(new RelevantKeywordsSettingMap()
                                                        .withBudgetPercent(100)
                                                        .withMode(RelevantKeywordsModeEnum.OPTIMAL))),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                                .withRelevantKeywords(new RelevantKeywordsSettingMap()
                                                        .withBudgetPercent(100)
                                                        .withMode(RelevantKeywordsModeEnum.OPTIMAL)))),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }


    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("748")
    public void updateNetworkStrategy() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                        .withId(id)
                                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                                        .withSearch(new TextCampaignSearchStrategyMap()
                                                                .withBiddingStrategyType(
                                                                        TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                                                        .withNetwork(new TextCampaignNetworkStrategyMap()
                                                                .withBiddingStrategyType(
                                                                        TextCampaignNetworkStrategyTypeEnum.SERVING_OFF)))),
                                new CampaignUpdateItemMap()
                                        .withId(idElse)
                                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                                        .withSearch(new TextCampaignSearchStrategyMap()
                                                                .withBiddingStrategyType(
                                                                        TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                                                        .withNetwork(new TextCampaignNetworkStrategyMap()
                                                                .withBiddingStrategyType(
                                                                        TextCampaignNetworkStrategyTypeEnum.SERVING_OFF))))),
                ExpectedResult.success(id), ExpectedResult.success(idElse));
        CampaignFakeInfo campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(id);
        assumeThat("LastChange у первой кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
        campaignFakeInfo = api.userSteps.campaignFakeSteps().fakeGetCampaignParams(idElse);
        assumeThat("LastChange у второй кампании обновился",
                campaignFakeInfo.getLastChange(), not(equalTo(lastChange)));
    }
}
