package ru.yandex.autotests.direct.api.campaigns.update;

import java.sql.Timestamp;
import java.time.LocalDateTime;

import com.yandex.direct.api.v5.campaigns.CampaignGetItem;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.enums.BannerType;
import ru.yandex.autotests.directapi.enums.CampaignType;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.greaterThan;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assumeThat;

/**
 * Created by lightelfik on 26.01.17.
 * https://st.yandex-team.ru/TESTIRT-10946
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Поверка LastChange на кампании и содержащихся в ней объектов после обновления какого либо конкретного поля")
@Issue("https://st.yandex-team.ru/DIRECT-60743")
public class CheckLastChangeAfterUpdateCampaignFieldsTest {

    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static DirectJooqDbSteps directJooqDbSteps = api.userSteps.getDirectJooqDbSteps().useShardForLogin(CLIENT);

    private static Long id;
    private static Long adGroupId;
    private static Long adId;

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addDefaultCampaign(CampaignType.TEXT);
        adGroupId = api.userSteps.adGroupsSteps().addDefaultGroup(id);
        adId = api.userSteps.adsSteps().addDefaultAd(adGroupId, BannerType.TEXT);
    }

    @Test
    public void setName() {
        Timestamp lastChange = Timestamp.valueOf(LocalDateTime.now().minusDays(5).withNano(0));
        directJooqDbSteps.campaignsSteps().setCampaignsLastChange(id, lastChange);
        directJooqDbSteps.adGroupsSteps().setPhrasesLastChange(adGroupId, lastChange);
        directJooqDbSteps.bannersSteps().setBannersLastChange(adId, lastChange);

        CampaignGetItem campaign = api.userSteps.campaignSteps().getCampaigns(id).get(0);
        String newName = campaign.getName().concat("42");

        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap().withId(id).withName(newName)),
                ExpectedResult.success(id)
        );
        Timestamp newLastChange = directJooqDbSteps.campaignsSteps().getCampaignById(id).getLastchange();
        Timestamp newAdGroupLastChange = directJooqDbSteps.adGroupsSteps().getPhrases(adGroupId).getLastchange();
        Timestamp newAdLastChange = directJooqDbSteps.bannersSteps().getBanner(adId).getLastchange();

        assumeThat("LastChange у группы объявлений не изменился",
                newAdGroupLastChange.toLocalDateTime(), equalTo(lastChange.toLocalDateTime()));
        assumeThat("LastChange у объявления не изменился",
                newAdLastChange.toLocalDateTime(), equalTo(lastChange.toLocalDateTime()));
        assertThat("LastChange у кампании изменился",
                newLastChange.toLocalDateTime(), greaterThan(lastChange.toLocalDateTime()));
    }

}
