package ru.yandex.autotests.direct.api.campaigns.update;

import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.darkside.datacontainers.jsonrpc.fake.CampaignFakeInfo;
import ru.yandex.autotests.directapi.darkside.model.Status;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.irt.testutils.allure.TestSteps.assertThat;

/**
 * Created by ginger on 28.08.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Features(CampaignsFeatures.UPDATE)
@Description("Проверка статусов кампании после обновления новой кампании")
@Tag(TagDictionary.TRUNK)
public class CheckStatusesAfterUpdateNewCampaignTest {

    //Дополнить проверками полей и статусов

    private static String client = CampaignsLogins.UPDATE_CLIENT;

    private static Long id;
    private static CampaignFakeInfo campaignFakeInfo;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(
                                new CampaignUpdateItemMap()
                                        .withId(id)
                        ),
                ExpectedResult.success());
        campaignFakeInfo =
                api.userSteps.getDarkSideSteps().getCampaignFakeSteps().fakeGetCampaignParams(id);
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("846")
    public void checkStatusModerate() {
        assertThat("у обновленной кампании StatusModerate = New",
                campaignFakeInfo.getStatusModerate(), equalTo(Status.NEW));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("847")
    public void checkStatusPostModerate() {
        assertThat("у обновленной кампании StatusPostModerate = New",
                campaignFakeInfo.getStatusPostModerate(), equalTo(Status.NEW));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("848")
    public void checkStatusShow() {
        assertThat("у обновленной кампании StatusShow = Yes",
                campaignFakeInfo.getStatusShow(), equalTo(Status.YES));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("849")
    public void checkStatusActive() {
        assertThat("у обновленной кампании StatusActive = No",
                campaignFakeInfo.getStatusActive(), equalTo(Status.NO));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("850")
    public void checkStatusBsSynced() {
        assertThat("у обновленной кампании StatusBsSynced = No",
                campaignFakeInfo.getStatusBsSynced(), equalTo(Status.NO));
    }
}
