package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;
import java.util.Collection;

import org.joda.time.DateTime;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignAddItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.JavaOrPerlExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * Created by pavryabov on 09.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Даты старта и окончания кампаний правильные по формату, но неправильные хронологически")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Tag(TagDictionary.TRUNK)
@RunWith(Parameterized.class)
public class DatesChronologicalTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static Long id;

    @Parameterized.Parameter(0)
    public String description;

    @Parameterized.Parameter(1)
    public String startDate;

    @Parameterized.Parameter(2)
    public String endDate;

    @Parameterized.Parameter(3)
    public JavaOrPerlExpectedResult expectedResult;

    @Parameterized.Parameters(name = "{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{
                {"StartDate в прошлом, EndDate сегодня",
                        DateTime.now().minusDays(1).toString(CampaignAddItemMap.DATE_PATTERN),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN),
                        JavaOrPerlExpectedResult.bothJavaAndPerl(5005, Api5ErrorDetails.START_DATE_CANT_BE_EARLIER_THAN_NOW)},
                {"StartDate в прошлом, EndDate в прошлом",
                        DateTime.now().minusDays(1).toString(CampaignAddItemMap.DATE_PATTERN),
                        DateTime.now().minusDays(1).toString(CampaignAddItemMap.DATE_PATTERN),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetails.START_DATE_CANT_BE_EARLIER_THAN_NOW),
                                        new Notification(5005, Api5ErrorDetails.END_DATE_MUST_FOLLOW_TODAY_DATE)))
                                .perl(ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetails.START_DATE_CANT_BE_EARLIER_THAN_NOW),
                                        new Notification(6000, Api5ErrorDetails.END_DATE_MUST_FOLLOW_TODAY_DATE)))},
                {"StartDate в будущем, EndDate сегодня",
                        DateTime.now().plusDays(1).toString(CampaignAddItemMap.DATE_PATTERN),
                        DateTime.now().toString(CampaignAddItemMap.DATE_PATTERN),
                        JavaOrPerlExpectedResult.bothJavaAndPerl(6000, Api5ErrorDetails.END_DATE_CANNOT_BE_BEFORE_START_DATE)},
                {"StartDate в прошлом, EndDate еще раньше",
                        DateTime.now().minusDays(1).toString(CampaignAddItemMap.DATE_PATTERN),
                        DateTime.now().minusDays(2).toString(CampaignAddItemMap.DATE_PATTERN),
                        JavaOrPerlExpectedResult
                                .java(ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetails.START_DATE_CANT_BE_EARLIER_THAN_NOW),
                                        new Notification(5005, Api5ErrorDetails.END_DATE_MUST_FOLLOW_TODAY_DATE)))
                                .perl(ExpectedResult.errors(
                                        new Notification(5005, Api5ErrorDetails.START_DATE_CANT_BE_EARLIER_THAN_NOW),
                                        new Notification(6000, Api5ErrorDetails.END_DATE_CANNOT_BE_BEFORE_START_DATE),
                                        new Notification(6000, Api5ErrorDetails.END_DATE_MUST_FOLLOW_TODAY_DATE)))},
        });
    }

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addCampaign(new CampaignAddItemMap()
                .defaultCampaignAddItem()
                .withStartDate(DateTime.now().plusDays(1).toString(CampaignAddItemMap.DATE_PATTERN))
                .withEndDate(DateTime.now().plusDays(2).toString(CampaignAddItemMap.DATE_PATTERN))
                .withDefaultTextCampaign()
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("852")
    public void addWithEndDate() {
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(new UpdateRequestMap()
                        .withCampaigns(new CampaignUpdateItemMap()
                                .withId(id)
                                .withStartDate(startDate)
                                .withEndDate(endDate)
                        ),
                expectedResult);
    }
}
