package ru.yandex.autotests.direct.api.campaigns.update;

import com.yandex.direct.api.v5.campaigns.DynamicTextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.MobileAppCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DynamicTextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.MobileAppCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.model.api5.general.ExpectedResult;
import ru.yandex.autotests.directapi.model.api5.general.Notification;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

/**
 * https://st.yandex-team.ru/DIRECT-78140
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Проверяем получение ошибки при изменении стратегии кампании на IMPRESSIONS_BELOW_SEARCH")
public class ImpressionsBelowSearchStrategyNegativeTest {

    private static final String CLIENT = CampaignsLogins.CLIENT;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
    }

    @Test
    public void updateTextCampaignWithImpressionsBelowSearchStrategy() {
        Long campaignId =  api.userSteps.campaignSteps().addDefaultTextCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap().withId(campaignId)
                        .withTextCampaign(new TextCampaignUpdateItemMap()
                                .withBiddingStrategy(new TextCampaignStrategyMap()
                                        .withSearch(new TextCampaignSearchStrategyMap().withBiddingStrategyType(
                                                TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))))),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.STRATEGY_NOT_SUPPORTED,
                        TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH)));
    }

    @Test
    public void updateMobileAppCampaignWithImpressionsBelowSearchStrategy() {
        Long campaignId =  api.userSteps.campaignSteps().addDefaultMobileAppCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap().withId(campaignId)
                        .withMobileAppCampaign(new MobileAppCampaignUpdateItemMap()
                                .withBiddingStrategy(new MobileAppCampaignStrategyMap()
                                        .withSearch(new MobileAppCampaignSearchStrategyMap().withBiddingStrategyType(
                                                MobileAppCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))))),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.STRATEGY_NOT_SUPPORTED,
                        TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH)));
    }

    @Test
    public void updateDynamicTextCampaignWithImpressionsBelowSearchStrategy() {
        Long campaignId =  api.userSteps.campaignSteps().addDefaultDynamicTextCampaign();
        api.userSteps.campaignSteps().shouldGetResultOnUpdate(
                new UpdateRequestMap().withCampaigns(new CampaignUpdateItemMap().withId(campaignId)
                        .withDynamicTextCampaign(new DynamicTextCampaignUpdateItemMap()
                                .withBiddingStrategy(new DynamicTextCampaignStrategyMap()
                                        .withSearch(new DynamicTextCampaignSearchStrategyMap().withBiddingStrategyType(
                                                DynamicTextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH))))),
                ExpectedResult.errors(new Notification(3500, Api5ErrorDetails.STRATEGY_NOT_SUPPORTED,
                        TextCampaignSearchStrategyTypeEnum.IMPRESSIONS_BELOW_SEARCH)));
    }
}
