package ru.yandex.autotests.direct.api.campaigns.update;

import java.util.Arrays;

import com.yandex.direct.api.v5.campaigns.DailyBudgetModeEnum;
import org.json.simple.JSONObject;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.DailyBudgetMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;

/**
 * Created by pavryabov on 09.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Неправильные типы в простых полях")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Tag(TagDictionary.TRUNK)
public class InvalidTypesOfFieldsTest {

    private static String client = CampaignsLogins.UPDATE_CLIENT;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(client);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(client);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @Description("Массив в поле Campaigns.ClientInfo")
    @ru.yandex.qatools.allure.annotations.TestCaseId("859")
    public void anArrayInClientInfo() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.CLIENT_INFO), Arrays.asList("clientInfo"));
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignUpdateItemMap.CLIENT_INFO)));
    }

    @Test
    @Description("null в поле Campaigns.ClientInfo")
    @ru.yandex.qatools.allure.annotations.TestCaseId("858")
    public void nullInClientInfo() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.CLIENT_INFO), "null");
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.CANNOT_HAVE_NULL_VALUE,
                        capitalize(CampaignUpdateItemMap.CLIENT_INFO)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("856")
    public void objectInClientInfo() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.CLIENT_INFO),
                new NotificationMap().defaultNotification().getBean());
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_STRING,
                        capitalize(CampaignUpdateItemMap.CLIENT_INFO)));
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("857")
    public void stringInDailyBudgetAmount() {
        JsonObject dailyBudget = new JsonObject()
                .with(capitalize(DailyBudgetMap.AMOUNT), "someString")
                .with(capitalize(DailyBudgetMap.MODE), DailyBudgetModeEnum.DISTRIBUTED);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignUpdateItemMap.ID), id)
                .with(capitalize(CampaignUpdateItemMap.DAILY_BUDGET), dailyBudget);
        JsonObject request = new JsonObject().with(capitalize(UpdateRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_CONTAIN_INTEGER_VALUE,
                        capitalize(DailyBudgetMap.AMOUNT))
        );
    }

    @Test
    @Description("Массив в поле Campaigns.StartDate")
    @ru.yandex.qatools.allure.annotations.TestCaseId("860")
    public void anArrayInStartDate() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.START_DATE), Arrays.asList("2015-15-15"));
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignUpdateItemMap.START_DATE)));
    }

    @Test
    @Description("Массив в поле Campaigns.EndDate")
    @ru.yandex.qatools.allure.annotations.TestCaseId("855")
    public void anArrayInEndDate() {
        JSONObject request = new JSONObject();
        JSONObject campaignUpdateItem = new JSONObject();
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.END_DATE), Arrays.asList("2015-15-15"));
        campaignUpdateItem.put(capitalize(CampaignUpdateItemMap.ID), id);
        request.put(capitalize(UpdateRequestMap.CAMPAIGNS), Arrays.asList(campaignUpdateItem));

        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(request,
                new Api5Error(8000, Api5ErrorDetails.FIELD_MUST_NOT_CONTAIN_ARRAY,
                        capitalize(CampaignUpdateItemMap.END_DATE)));
    }
}
