package ru.yandex.autotests.direct.api.campaigns.update;

import com.yandex.direct.api.v5.campaigns.SmsEventsEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSettingsEnum;
import com.yandex.direct.api.v5.general.YesNoEnum;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

import ru.yandex.aqua.annotations.project.Aqua;
import ru.yandex.autotests.direct.api.campaigns.CampaignsFeatures;
import ru.yandex.autotests.direct.api.campaigns.CampaignsLogins;
import ru.yandex.autotests.direct.utils.beans.JsonObject;
import ru.yandex.autotests.direct.utils.tags.TagDictionary;
import ru.yandex.autotests.directapi.apiclient.config.Semaphore;
import ru.yandex.autotests.directapi.apiclient.errors.Api5Error;
import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorDetails;
import ru.yandex.autotests.directapi.model.api5.campaigns.CampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.EmailSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.NotificationMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.SmsSettingsMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignNetworkStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSearchStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignSettingMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignStrategyMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.TextCampaignUpdateItemMap;
import ru.yandex.autotests.directapi.model.api5.campaigns.UpdateRequestMap;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.rules.Trashman;
import ru.yandex.qatools.Tag;
import ru.yandex.qatools.allure.annotations.Description;
import ru.yandex.qatools.allure.annotations.Features;
import ru.yandex.qatools.allure.annotations.Issue;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

import static org.apache.commons.lang3.StringUtils.capitalize;
import static org.apache.commons.lang3.StringUtils.uncapitalize;

/**
 * Created by pavryabov on 09.09.15.
 * https://st.yandex-team.ru/TESTIRT-6809
 */
@Aqua.Test
@Features(CampaignsFeatures.UPDATE)
@Description("Неправильные значения в полях, принимающих Enum'ы")
@Issue("https://st.yandex-team.ru/DIRECT-34570")
@Tag(TagDictionary.TRUNK)
public class InvalidValuesInEnumsTest {

    private static final String CLIENT = CampaignsLogins.UPDATE_CLIENT;
    private static Long id;

    @ClassRule
    public static ApiSteps api = new ApiSteps().version(5).as(CLIENT);

    @ClassRule
    public static SemaphoreRule semaphore = Semaphore.getSemaphore();

    @Rule
    public Trashman trasher = new Trashman(api);

    private static final String PARAMS = "params";

    @BeforeClass
    public static void initTest() {
        api.userSteps.clientFakeSteps().fakeClearClientSpentUnits(CLIENT);
        id = api.userSteps.campaignSteps().addDefaultTextCampaign();
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("861")
    public void invalidValueInSmsSettingsEvents() {
        JsonObject smsSettings = new JsonObject()
                .with(capitalize(SmsSettingsMap.TIME_FROM), SmsSettingsMap.VALID_TIME_FROM)
                .with(capitalize(SmsSettingsMap.TIME_TO), SmsSettingsMap.VALID_TIME_TO)
                .with(capitalize(SmsSettingsMap.EVENTS), new String[]{uncapitalize(SmsEventsEnum.FINISHED.toString())});
        JsonObject notification = new JsonObject()
                .with(capitalize(NotificationMap.EMAIL_SETTINGS),
                        new EmailSettingsMap().defaultEmailSettings().getBean())
                .with(capitalize(NotificationMap.SMS_SETTINGS), smsSettings);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignUpdateItemMap.NOTIFICATION), notification)
                .with(capitalize(CampaignUpdateItemMap.ID), id);
        JsonObject request = new JsonObject().with(capitalize(UpdateRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.ELEMENT_OF_ARRAY_CONTAINS_INCORRECT_ENUMERATE_VALUE,
                        capitalize(SmsSettingsMap.EVENTS))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("862")
    public void invalidValueInTextCampaignSettingsOption() {
        JsonObject setting = new JsonObject()
                .with(capitalize(TextCampaignSettingMap.OPTION),
                        uncapitalize(TextCampaignSettingsEnum.ADD_TO_FAVORITES.toString()))
                .with(capitalize(TextCampaignSettingMap.VALUE), YesNoEnum.NO);
        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignUpdateItemMap.SETTINGS), new Object[]{setting});
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN), textCampaign)
                .with(capitalize(CampaignUpdateItemMap.ID), id);
        JsonObject request = new JsonObject().with(capitalize(UpdateRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(TextCampaignSettingMap.OPTION))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("863")
    public void invalidValueInTextCampaignSearchStrategyName() {
        JsonObject searchStrategy = new JsonObject()
                .with(capitalize(TextCampaignSearchStrategyMap.BIDDING_STRATEGY_TYPE),
                        TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
        JsonObject strategy = new JsonObject()
                .with(capitalize(TextCampaignStrategyMap.SEARCH), searchStrategy)
                .with(capitalize(TextCampaignStrategyMap.NETWORK),
                        new TextCampaignNetworkStrategyMap()
                                .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE)
                                .getBean());
        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignUpdateItemMap.BIDDING_STRATEGY), strategy);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN), textCampaign)
                .with(capitalize(CampaignUpdateItemMap.ID), id);
        JsonObject request = new JsonObject().with(capitalize(UpdateRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(TextCampaignSearchStrategyMap.BIDDING_STRATEGY_TYPE))
        );
    }

    @Test
    @ru.yandex.qatools.allure.annotations.TestCaseId("864")
    public void invalidValueInTextCampaignNetworkStrategyName() {
        JsonObject networkStrategy = new JsonObject()
                .with(capitalize(TextCampaignNetworkStrategyMap.BIDDING_STRATEGY_TYPE),
                        TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
        JsonObject strategy = new JsonObject()
                .with(capitalize(TextCampaignStrategyMap.SEARCH),
                        new TextCampaignSearchStrategyMap()
                                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION).getBean())
                .with(capitalize(TextCampaignStrategyMap.NETWORK), networkStrategy);
        JsonObject textCampaign = new JsonObject()
                .with(capitalize(TextCampaignUpdateItemMap.BIDDING_STRATEGY), strategy);
        JsonObject campaign = new JsonObject()
                .with(capitalize(CampaignUpdateItemMap.TEXT_CAMPAIGN), textCampaign)
                .with(capitalize(CampaignUpdateItemMap.ID), id);
        JsonObject request = new JsonObject().with(capitalize(UpdateRequestMap.CAMPAIGNS), new Object[]{campaign});
        api.userSteps.campaignSteps().expectErrorOnCampaignsUpdate(
                request,
                new Api5Error(8000, Api5ErrorDetails.INCORRECT_ENUMERATE_VALUE,
                        capitalize(TextCampaignSearchStrategyMap.BIDDING_STRATEGY_TYPE))
        );
    }
}
